# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' rcpp_convert_time
#'
#' @noRd
rcpp_convert_time <- function(hms) {
    .Call(`_gtfsrouter_rcpp_convert_time`, hms)
}

#' rcpp_time_to_seconds
#'
#' Vectorize the above function
#'
#' @noRd
rcpp_time_to_seconds <- function(times) {
    .Call(`_gtfsrouter_rcpp_time_to_seconds`, times)
}

#' rcpp_csa_isochrone
#'
#' Calculate isochrones using Connection Scan Algorithm for GTFS data. Works
#' largely as rcpp_csa. Returns a list of integer vectors, with [i] holding
#' sequences of stations on a given route, the end one being the terminal
#' isochrone point, and [i+1] holding correpsonding trip numbers.
#'
#' All elements of all data are 1-indexed
#'
#' @noRd
rcpp_csa_isochrone <- function(timetable, transfers, nstations, ntrips, start_stations, start_time, end_time) {
    .Call(`_gtfsrouter_rcpp_csa_isochrone`, timetable, transfers, nstations, ntrips, start_stations, start_time, end_time)
}

#' rcpp_csa_matrix
#'
#' Not really CSA, rather a full-timetable scan for all connections from
#' everywhere to everywhere which returns only start and end times for each
#' pair of (start, end) points.
#'
#' @noRd
rcpp_csa_matrix <- function(timetable, transfers, nstations, ntrips, start_stations, end_stations, start_time, max_transfers) {
    .Call(`_gtfsrouter_rcpp_csa_matrix`, timetable, transfers, nstations, ntrips, start_stations, end_stations, start_time, max_transfers)
}

#' rcpp_make_timetable
#'
#' Make timetable from GTFS stop_times. Both stop_ids and trip_ids are vectors
#' of unique values which are converted to unordered_maps on to 1-indexed
#' integer values.
#'
#' @noRd
rcpp_make_timetable <- function(stop_times, stop_ids, trip_ids) {
    .Call(`_gtfsrouter_rcpp_make_timetable`, stop_times, stop_ids, trip_ids)
}

#' rcpp_csa
#'
#' Connection Scan Algorithm for GTFS data. The timetable has 
#' [deparutre_station, arrival_station, departure_time, arrival_time,
#'     trip_id],
#' with all entries as integer values, including times in seconds after
#' 00:00:00. The station and trip IDs can be mapped back on to actual station
#' IDs, but do not necessarily form a single set of unit-interval values
#' because the timetable is first cut down to only that portion after the
#' desired start time. These are nevertheless used as direct array indices
#' throughout, so are all size_t objects rather than int. All indices in the
#' timetable and transfers DataFrames, as well as start_/end_stations, are
#' 1-based, but they are still used directly which just means that the first
#' entries (that is, entry [0]) of station and trip vectors are never used.
#'
#' @noRd
rcpp_csa <- function(timetable, transfers, nstations, ntrips, start_stations, end_stations, start_time, max_transfers) {
    .Call(`_gtfsrouter_rcpp_csa`, timetable, transfers, nstations, ntrips, start_stations, end_stations, start_time, max_transfers)
}

