% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{body_add_gt}
\alias{body_add_gt}
\title{Add 'gt' table into a Word document}
\usage{
body_add_gt(
  x,
  value,
  align = "center",
  pos = c("after", "before", "on"),
  caption_location = c("top", "bottom", "embed"),
  caption_align = "left",
  split = FALSE,
  keep_with_next = TRUE
)
}
\arguments{
\item{x}{`rdocx` object}

\item{value}{`gt_tbl` object}

\item{align}{left, center (default) or right.}

\item{pos}{where to add the gt table relative to the cursor, one of "after"
(default), "before", "on" (end of line).}

\item{caption_location}{top (default), bottom, or embed indicating if the
title and subtitle should be listed above, below, or be embedded in the
table}

\item{caption_align}{left (default), center, or right. Alignment of caption
(title and subtitle). Used when `caption_location` is not "embed".}

\item{split}{set to TRUE if you want to activate Word option 'Allow row to
break across pages'.}

\item{keep_with_next}{Word option 'keep rows together' can be activated when
TRUE. It avoids page break within tables.}
}
\value{
An updated rdocx object with a 'gt' table inserted
}
\description{
Add a 'gt' table into a Word document. The table will be processed
  using the \link[gt]{as_word} function then inserted either after, before,
  or on the cursor location.
}
\examples{

 library(officer)
 library(gt)

 gt_tbl <- gt(head(exibble))

 doc <- read_docx()
 doc <- body_add_gt(doc, value = gt_tbl)
 fileout <- tempfile(fileext = ".docx")
 print(doc, target = fileout)


}
\seealso{
flextable::body_add_flextable()
}
