% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-assign_summary_type.R
\name{assign_summary_type}
\alias{assign_summary_type}
\title{Assigns summary type (e.g. continuous, categorical, or dichotomous).}
\usage{
assign_summary_type(data, variable, class, summary_type)
}
\arguments{
\item{data}{Data frame.}

\item{variable}{Vector of column name.}

\item{class}{Vector of classes (e.g. numeric, character, etc.)
corresponding one-to-one with the names in \code{variable}.}

\item{summary_type}{list that includes specified summary types,
e.g. \code{summary_type = list(age = "continuous")}}
}
\value{
Vector summary types \code{c("continuous", "categorical", "dichotomous")}.
}
\description{
For variables where the summary type was not specified in the function
call of \code{fmt_table1}, \code{assign_summary_type} assigns a type based on class and
number of unique levels.
}
\examples{
gtsummary:::assign_summary_type(
  data = mtcars,
  variable =  names(mtcars),
  class = apply(mtcars, 2, class),
  summary_type = NULL
)
}
\keyword{internal}
