% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_gt.R
\name{as_gt}
\alias{as_gt}
\title{Convert gtsummary object to a gt_tbl object}
\usage{
as_gt(x, include = NULL, exclude = NULL, omit = NULL)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Character vector naming gt commands to include in printing.
Default is \code{NULL}, which utilizes all commands in \code{x$gt_calls}.}

\item{exclude}{Character vector naming gt commands to exclude in printing.
Default is \code{NULL}.}

\item{omit}{DEPRECATED. Argument is synonymous with \code{exclude}
vector of named gt commands to omit. Default is \code{NULL}}
}
\value{
A \code{gt_tbl} object
}
\description{
Function converts gtsummary objects to a gt_tbl objects.
Function is used in the background when the results are printed or knit.
A user can use this function if they wish to add customized formatting
available via the \href{https://gt.rstudio.com/index.html}{gt package}.
Review the
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_summary.html#advanced}{tbl_summary vignette}
or
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#advanced}{tbl_regression vignette}
for detailed examples in the 'Advanced Customization' section.
}
\section{Example Output}{


\if{html}{\figure{as_gt_ex.png}{options: width=50\%}}
}

\examples{
\donttest{
as_gt_ex <-
  trial[c("trt", "age", "response", "grade")] \%>\%
  tbl_summary(by = trt) \%>\%
  as_gt()
}
}
\seealso{
\link{tbl_summary} \link{tbl_regression} \link{tbl_uvregression} \link{tbl_survival}
}
\author{
Daniel D. Sjoberg
}
