% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.tbl_survfit}
\alias{inline_text.tbl_survfit}
\title{Report statistics from survfit tables inline}
\usage{
\method{inline_text}{tbl_survfit}(
  x,
  time = NULL,
  prob = NULL,
  level = NULL,
  estimate_fun = NULL,
  pvalue_fun = function(x) style_pvalue(x, prepend_p = TRUE),
  ...
)
}
\arguments{
\item{x}{Object created from  \link{tbl_survfit}}

\item{time}{time for which to return survival probabilities.}

\item{prob}{probability with values in (0,1)}

\item{level}{Level of the variable to display for categorical variables.
Can also specify the 'Unknown' row.  Default is \code{NULL}}

\item{estimate_fun}{Function to round and format coefficient estimates.
Default is \link{style_sigfig} when the coefficients are not transformed, and
\link{style_ratio} when the coefficients have been exponentiated.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{tbl_survfit used}
}
\value{
A string reporting results from a gtsummary table
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
Extracts and returns statistics from a \code{tbl_survfit} object for
inline reporting in an R markdown document. Detailed examples in the
\href{http://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
library(survival)
# fit survfit
fit1 <- survfit(Surv(ttdeath, death) ~ trt, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ 1, trial)

# sumarize survfit objects
tbl1 <- tbl_survfit(
  fit1,
  times = c(12, 24),
  label = "Treatment",
  label_header = "**{time} Month**"
)

tbl2 <- tbl_survfit(
  fit2,
  probs = 0.5,
  label_header = "**Median Survival**"
)

# report results inline
inline_text(tbl1, time = 24, level = "Drug B")
inline_text(tbl2, prob = 0.5)
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
