% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_gtsummary.R
\name{theme_gtsummary}
\alias{theme_gtsummary}
\alias{theme_gtsummary_journal}
\alias{theme_gtsummary_compact}
\alias{theme_gtsummary_printer}
\title{Available gtsummary themes}
\usage{
theme_gtsummary_journal(journal = "jama")

theme_gtsummary_compact()

theme_gtsummary_printer(
  print_engine = c("gt", "kable", "kable_extra", "flextable", "huxtable", "tibble")
)
}
\arguments{
\item{journal}{String indicating the journal theme to follow.
\itemize{
\item \code{"jama"} Journal of the American Medical Association
}}

\item{print_engine}{String indicating the print engine. Default is \code{"gt"}}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
The following themes are available to use within the gtsummary package.
Use the \code{\link[=set_gtsummary_theme]{set_gtsummary_theme()}} function to set a theme.
}
\section{Themes}{

\itemize{
\item \code{theme_gtsummary_journal(journal=)}
\itemize{
\item \code{journal = "jama"}
\itemize{
\item sets theme to align with the JAMA reporting guidelines
\item large p-values are rounded to two decimal places
\item in \code{tbl_summary()} the IQR is separated with a dash, rather than comma
\item in \code{tbl_summary()} the percent symbol is not printed next to percentages
}
}
\item \code{theme_gtsummary_compact()}
\itemize{
\item tables printed with gt, flextable, and huxtable will be compact with smaller font size and reduced cell padding
}
\item \code{theme_gtsummary_printer(print_engine=)}
\itemize{
\item \code{"gt"} sets the gt package as the default print engine
\item \code{"kable"} sets the \code{knitr::kable()} function as the default print engine
\item \code{"flextable"} sets the flextable package as the default print engine
\item \code{"kable_extra"} sets the kableExtra package as the default print engine
\item \code{"huxtable"} sets the huxtable package as the default print engine
}
}

Use \code{reset_gtsummary_theme()} to restore the default settings

Review the \href{http://www.danieldsjoberg.com/gtsummary/dev/articles/themes.html}{themes vignette}
to create your own themes.
}

\section{Example Output}{

\if{html}{Example}

\if{html}{\figure{set_gtsummary_theme_ex1.png}{options: width=70\%}}
}

\examples{
# Setting JAMA theme for gtsummary
set_gtsummary_theme(theme_gtsummary_journal("jama"))
# Themes can be combined by including more than one
set_gtsummary_theme(theme_gtsummary_compact())

set_gtsummary_theme_ex1 <-
  trial \%>\%
  dplyr::select(age, grade, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  add_stat_label() \%>\%
  as_gt()

# reset gtsummary theme
reset_gtsummary_theme()
}
\seealso{
\code{\link[=set_gtsummary_theme]{set_gtsummary_theme()}}
}
