% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.R
\name{add_p.tbl_survfit}
\alias{add_p.tbl_survfit}
\title{Adds p-value to survfit table}
\usage{
\method{add_p}{tbl_survfit}(
  x,
  test = "logrank",
  test.args = NULL,
  pvalue_fun = style_pvalue,
  include = everything(),
  quiet = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{"tbl_survfit"}}

\item{test}{string indicating test to use. Must be one of \code{"logrank"}, \code{"survdiff"},
\code{"petopeto_gehanwilcoxon"}, \code{"coxph_lrt"}, \code{"coxph_wald"}, \verb{"coxph_score".}
See details below}

\item{test.args}{List of formulas containing additional arguments to pass to
tests that accept arguments. For example, add an argument for all t-tests,
use \code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{include}{Variables to include in output. Input may be a vector of
quoted variable names, unquoted variable names, or tidyselect select helper
functions. Default is \code{everything()}.}

\item{quiet}{Logical indicating whether to print messages in console. Default is
\code{FALSE}}

\item{...}{Not used}
}
\description{
\lifecycle{maturing}
Calculate and add a p-value
}
\section{test argument}{

The most common way to specify \verb{test=} is by using a single string indicating
the test name. However, if you need to specify different tests within the same
table, the input in flexible using the list notation common throughout the
gtsummary package. For example, the following code would call the log-rank test,
and a second test of the \emph{G-rho} family.\if{html}{\out{<div class="sourceCode r">}}\preformatted{... \%>\%
  add_p(test = list(trt ~ "logrank", grade ~ "survdiff"),
        test.args = grade ~ list(rho = 0.5))
}\if{html}{\out{</div>}}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_p_tbl_survfit_ex1.png}{options: width=55\%}}

\if{html}{Example 2}

\if{html}{\figure{add_p_tbl_survfit_ex2.png}{options: width=45\%}}
}

\examples{
\dontshow{if (broom.helpers::.assert_package("survival", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

gts_survfit <-
  list(
    survfit(Surv(ttdeath, death) ~ grade, trial),
    survfit(Surv(ttdeath, death) ~ trt, trial)
  ) \%>\%
  tbl_survfit(times = c(12, 24))

# Example 1 ----------------------------------
add_p_tbl_survfit_ex1 <-
  gts_survfit \%>\%
  add_p()

# Example 2 ----------------------------------
# Pass `rho=` argument to `survdiff()`
add_p_tbl_survfit_ex2 <-
  gts_survfit \%>\%
  add_p(test = "survdiff", test.args = list(rho = 0.5))
\dontshow{\}) # examplesIf}
}
\seealso{
Other tbl_survfit tools: 
\code{\link{add_n.tbl_survfit}()},
\code{\link{add_nevent.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_survfit}()}
}
\concept{tbl_survfit tools}
