% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.tbl_continuous.R
\name{add_p.tbl_continuous}
\alias{add_p.tbl_continuous}
\title{Add p-values}
\usage{
\method{add_p}{tbl_continuous}(
  x,
  test = NULL,
  pvalue_fun = label_style_pvalue(digits = 1),
  include = everything(),
  test.args = NULL,
  group = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_continuous})\cr
table created with \code{tbl_continuous()}}

\item{test}{List of formulas specifying statistical tests to perform for each
variable.
Default is two-way ANOVA when \verb{by=} is not \code{NULL}, and has the same defaults
as \code{add_p.tbl_continuous()} when \code{by = NULL}.
See \link{tests} for details, more tests, and instruction for implementing a custom test.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{test.args}{(\code{\link[=syntax]{formula-list-selector}})\cr
Containing additional arguments to pass to tests that accept arguments.
For example, add an argument for all t-tests, use
\code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}.}

\item{group}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable name of an ID or grouping variable. The column can be used to
calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \code{group} argument.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
'tbl_continuous' object
}
\description{
Add p-values
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("cardx", reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
trial |>
  tbl_continuous(variable = age, by = trt, include = grade) |>
  add_p()
\dontshow{\}) # examplesIf}
}
