% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_difference.R
\name{add_difference.tbl_summary}
\alias{add_difference.tbl_summary}
\title{Add differences between groups}
\usage{
\method{add_difference}{tbl_summary}(
  x,
  test = NULL,
  group = NULL,
  adj.vars = NULL,
  test.args = NULL,
  conf.level = 0.95,
  include = everything(),
  pvalue_fun = label_style_pvalue(digits = 1),
  estimate_fun = list(c(all_continuous(), all_categorical(FALSE)) ~ label_style_sigfig(),
    all_dichotomous() ~ label_style_sigfig(scale = 100, suffix = "\%"), all_tests("smd")
    ~ label_style_sigfig()),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
table created with \code{tbl_summary()}}

\item{test}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the tests/methods to perform for each variable, e.g.
\code{list(all_continuous() ~ "t.test", all_dichotomous() ~ "prop.test", all_categorical(FALSE) ~ "smd")}.

See below for details on default tests and \link[=tests]{?tests} for details on available
tests and creating custom tests.}

\item{group}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable name of an ID or grouping variable. The column can be used to
calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \code{group} argument.}

\item{adj.vars}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in adjusted calculations (e.g. in ANCOVA models).
Default is \code{NULL}.}

\item{test.args}{(\code{\link[=syntax]{formula-list-selector}})\cr
Containing additional arguments to pass to tests that accept arguments.
For example, add an argument for all t-tests, use
\code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}.}

\item{conf.level}{(\code{numeric})\cr
a scalar in the interval \verb{(0, 1)} indicating the confidence level. Default is 0.95}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{estimate_fun}{(\code{\link[=syntax]{formula-list-selector}})\cr
List of formulas specifying the functions
to round and format differences and confidence limits.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table of class \code{"tbl_summary"}
}
\description{
Adds difference to tables created by \code{\link[=tbl_summary]{tbl_summary()}}.
The difference between two groups (typically mean or rate difference) is added
to the table along with the difference's confidence interval and a p-value (when applicable).
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("broom", ref = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  select(trt, age, marker, response, death) \%>\%
  tbl_summary(
    by = trt,
    statistic =
      list(
        all_continuous() ~ "{mean} ({sd})",
        all_dichotomous() ~ "{p}\%"
      ),
    missing = "no"
  ) |>
  add_n() |>
  add_difference()

# Example 2 ----------------------------------
# ANCOVA adjusted for grade and stage
trial |>
  select(trt, age, marker, grade, stage) \%>\%
  tbl_summary(
    by = trt,
    statistic = list(all_continuous() ~ "{mean} ({sd})"),
    missing = "no",
    include = c(age, marker, trt)
  ) |>
  add_n() |>
  add_difference(adj.vars = c(grade, stage))
\dontshow{\}) # examplesIf}
}
