\name{read.snpdata.mach}
\alias{read.snpdata.mach}
\title{Read genotype dosages in the format output by MACH}
\description{
  Reads snp coding information and genotype data from paired
  \code{.mlinfo} and \code{.mldose} files, as generated by the MACH and
  minimac genotype imputation programs, and returns the data in a
  standard format (see \link{snpdata}) that can be used by other
  functions in this package.
}
\usage{
read.snpdata.mach(fileroot, tol.af = 0.01, phenotypes = NULL)
}
\arguments{
  \item{fileroot}{a filename root to which \code{.mlinfo} and \code{.mldose}
    extensions will be appended.}
  \item{tol.af}{a tolerence for checking allele frequencies between the
    two files read.}
  \item{phenotypes}{if not \code{NULL}, a data frame of phenotypes to be merged with the
    genotypes; must contain a column called MACHID which is used to
    match against the first column of the mldose file.}  
}
\details{
  This function will (just) work as is with HapMap imputed single chromosomes and
  4000 individuals.
  Need to comment on how to extract large numbers of SNPs before feeding
  to R.  
}
\value{
Returns a list with snpinfo and data slots, see \link{snpdata}.
}
\references{
  Information about the MACH and minimac programs for genotype imputation, including
  their output formats, can be found at
  \url{http://www.sph.umich.edu/csg/abecasis/MACH}.
}
\author{
  Toby Johnson \email{T.Johnson@qmul.ac.uk}
}