% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_inertia_from_tree.R
\name{plot_inertia_from_tree}
\alias{plot_inertia_from_tree}
\alias{get_inertia_from_tree}
\title{Plot inertia, absolute loss and relative loss from a classification tree}
\usage{
plot_inertia_from_tree(tree, k_max = 15)

get_inertia_from_tree(tree, k_max = 15)
}
\arguments{
\item{tree}{A dendrogram, i.e. an \link[stats:hclust]{stats::hclust} object,
an \link[FactoMineR:HCPC]{FactoMineR::HCPC} object or an object that can be converted to an
\link[stats:hclust]{stats::hclust} object with \code{\link[stats:as.hclust]{stats::as.hclust()}}.}

\item{k_max}{Maximum number of clusters to return / plot.}
}
\value{
A \code{ggplot2} plot or a tibble.
}
\description{
Plot inertia, absolute loss and relative loss from a classification tree
}
\examples{
hc <- hclust(dist(USArrests))
get_inertia_from_tree(hc)
plot_inertia_from_tree(hc)
}
\keyword{tree}
