% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_dictionary.R
\name{view_dictionary}
\alias{view_dictionary}
\alias{view_detailed_dictionary}
\alias{to_DT}
\title{Display the variable dictionary of a data frame in the RStudio viewer}
\usage{
view_dictionary(data = NULL, details = c("basic", "none", "full"))

view_detailed_dictionary(data = NULL)

to_DT(
  x,
  caption = NULL,
  column_labels = list(pos = "#", variable = "Variable", col_type = "Type", label =
    "Variable label", values = "Values", missing = "Missing values", unique_values =
    "Unique values", na_values = "User-defined missings (values)", na_range =
    "User-defined missings (range)")
)
}
\arguments{
\item{data}{a data frame, a tibble or a survey object
(if \code{NULL}, will use the text you currently select in \strong{RStudio}, useful
if the function is called through the corresponding addin)}

\item{details}{add details about each variable (see \code{\link[labelled:look_for]{labelled::look_for()}})}

\item{x}{a tibble returned by \code{look_for()}}

\item{caption}{an optional caption for the table}

\item{column_labels}{Optional column labels}
}
\description{
Generates an interactive variable dictionary based on \code{\link[labelled:look_for]{labelled::look_for()}}.
Accepts data frames, tibbles, and also survey objects.
}
\note{
\code{to_DT()} is an utility to convert the result of \code{\link[labelled:look_for]{labelled::look_for()}} into
a \code{\link[DT:datatable]{DT::datatable()}}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
iris |> view_dictionary()
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed(c("DT", "htmltools", "htmlwidgets"))) withAutoprint(\{ # examplesIf}
iris |> labelled::look_for(details = TRUE) |> to_DT()
\dontshow{\}) # examplesIf}
}
\keyword{utilities}
