% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gutenberg_languages}
\alias{gutenberg_languages}
\title{Metadata about Project Gutenberg languages}
\format{
A tbl_df (see tibble or dplyr) with one row for each
author, with the columns
\describe{
  \item{gutenberg_id}{Unique identifier for the work that can
  be used to join with the \link{gutenberg_metadata} dataset}
  \item{language}{Language ISO 639 code. Two
  letter code if one exists, otherwise three letter.}
  \item{total_languages}{Number of languages for this work.}
}
}
\usage{
gutenberg_languages
}
\description{
Data frame with metadata about the languages of each Project
Gutenberg work.
}
\details{
To find the date on which this metadata was last updated,
run \code{attr(gutenberg_languages, "date_updated")}.
}
\examples{

# date last updated
attr(gutenberg_languages, "date_updated")

}
\seealso{
\link{gutenberg_metadata}, \link{gutenberg_subjects}
}
\keyword{datasets}
