% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{n}
\alias{n}
\alias{n,studies-method}
\alias{n,associations-method}
\alias{n,variants-method}
\alias{n,traits-method}
\title{Number of GWAS Catalog entities}
\usage{
n(x, unique = FALSE)

\S4method{n}{studies}(x, unique = FALSE)

\S4method{n}{associations}(x, unique = FALSE)

\S4method{n}{variants}(x, unique = FALSE)

\S4method{n}{traits}(x, unique = FALSE)
}
\arguments{
\item{x}{A \linkS4class{studies}, an
\linkS4class{associations}, a \linkS4class{variants}, or a
\linkS4class{traits} object.}

\item{unique}{Whether to count only unique entries (\code{TRUE}) or not
(\code{FALSE}).}
}
\value{
An integer scalar.
}
\description{
This function returns the number of unique entities in a GWAS Catalog object.
}
\examples{
# Determine number of studies
n(studies_ex01)

# Determine number of associations
n(associations_ex01)

# Determine number of variants
n(variants_ex01)

# Determine number of traits
n(traits_ex01)

}
