% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betareg_gwbr.R
\name{betareg_gwbr}
\alias{betareg_gwbr}
\title{Global Beta Regression Model}
\usage{
betareg_gwbr(
  yvar,
  xvar,
  data,
  link = c("logit", "probit", "loglog", "cloglog"),
  maxint = 100
)
}
\arguments{
\item{yvar}{A vector with the response variable name.}

\item{xvar}{A vector with descriptive variable(s) name(s).}

\item{data}{A data set object with \code{yvar} and \code{xvar}.}

\item{link}{The link function used in modeling. The options are: \code{"logit"}, \code{"probit"}, \code{"loglog"} or \code{"cloglog"}. The default is \code{"logit"}.}

\item{maxint}{A Maximum number of iterations to numerically maximize the log-likelihood function in search of the estimators. The default is \code{maxint=100}.}
}
\value{
A list that contains:

\itemize{
\item \code{parameter_estimates} - Parameter estimates.
\item \code{phi} - Precision parameter estimate.
\item \code{residuals} - A vector of residuals (observed-fitted).
\item \code{log_likelihood} - Log-likelihood of the fitted model.
\item \code{aicc} - Corrected Akaike information criterion.
\item \code{r2} - Pseudo R2 and adjusted pseudo R2 statistics.
\item \code{bp_test} - Breusch-Pagan test for heteroscedasticity.
\item \code{link_function} - The link function used in modeling.
\item \code{n_iter} - Number of iterations used in convergence.
}
}
\description{
Fits a global regression model using the beta distribution, recommended for rates and proportions, via maximum likelihood using a parametrization with mean (transformed by the link function) and precision parameter (called phi). For more details see Ferrari and Cribari-Neto (2004).
}
\examples{
data(saopaulo)
output_list=betareg_gwbr("prop_landline",c("prop_urb","prop_poor"),saopaulo)

## Parameters
output_list$parameter_estimates

## R2 and AICc
output_list$r2
output_list$aicc
}
