% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genComplResid.R
\name{genComplResid}
\alias{genComplResid}
\title{genComplResid}
\usage{
genComplResid(U, Delta, Phi, blkID, m = 50, X = NULL)
}
\arguments{
\item{U}{a nx1 vector containing the survival times. \code{U = min(C, T)} 
where \code{C} is the censoring time, and \code{T} the failure time}

\item{Delta}{a nx1 vector containing the censoring indicator}

\item{Phi}{a nxn kinship matrix}

\item{blkID}{a nx1 vector with entries identifying correlated groups of 
observations. The number of censored individuals in each group cannot exceed
1000 (see \bold{Details})}

\item{m}{default=50. Number of imputations used to generate the completed 
vector of residuals}

\item{X}{a nxp \bold{matrix} of p covariates. Each row represents a different 
individual, and each column represents a different numeric covariate. If no 
covariates are present, \code{X} can be left as \code{NULL}}
}
\value{
The function produces a list consisting of:

\item{compResid}{the completed vector of residuals}

\item{herit}{the estimate of the polygenic heritability parameter}

\item{covPar}{the estimate of the vector of covariate parameters (if 
applicable)}
}
\description{
Generates a completed vector of residuals
}
\details{
This function involves three steps. The first two are similar in spirit to
the two-stage procedure of Othus and Li (2010).
\enumerate{
\item The vector of covariate parameters and the monotone increasing function
of the transformation model with censored data (Cheng et al., 1995) are 
estimated under the working independence assumption following the algorithm 
of Chen et al. (2002) and used to compute raw residuals;
\item The polygenic heritability parameter is estimated which is a measure of
the dependence between the survival traits of correlated groups that cannot 
be attributed to the SNP set under investigation. This estimate is used to 
deduce the approximate covariance matrix of the raw residuals.
\item An imputation procedure is employed to replace the censored raw 
residuals by the mean of multiple imputed values generated from the posterior
distribution of the uncensored version with the restriction to be larger than
the original censored values, componentwise. The completed vector of 
residuals is then deduced and standardized. A scale parameter is used to 
reflect the fact that we are using multiple imputed values rather than real 
observations.
}
\bold{Warning:} Correlated groups identified by the vector \code{blkID} most
often corresponds to families or blocks of the block-diagonal kinship matrix
\bold{Phi}. Larger groups such as regions of residence can be considered, for
example to take into account population stratification or cryptic relatedness.
However, the number of censored individuals in each group cannot exceed 1000
as the test makes use of the distribution function of the multivariate normal 
distribution for which the maximum dimension is 1000 in the function 
\bold{pmvnorm} of the package \pkg{mvtnorm}.

Simulation studies reported in Leclerc et al. (2015) suggest that the use
of \code{m = 50} imputations guarantees a reasonable power in practice.

\bold{Warning:} No missing data is allowed for \code{U}, \code{Delta}, 
\code{Phi}, \code{blkID}, and \code{X}.
}
\examples{
data(simGyriq)
for (i in seq_along(simGyriq)) assign(names(simGyriq)[i], simGyriq[[i]])

cr <- genComplResid(U, Delta, Phi, blkID, m=50, X)
}
\author{
Martin Leclerc <martin.leclerc.5@ulaval.ca> and Lajmi Lakhal Chaieb
 <lakhal@mat.ulaval.ca>
}
\references{
Chen K, Jin Z, Ying Z. 2002. Semiparametric analysis of 
transformation models with censored data. Biometrika 89:659-668.

Cheng SC, Wei LJ, Ying Z. 1995. Analysis of transformation models with 
censored data. Biometrika 82:835-845.

Leclerc M, The Consortium of Investigators of Modifiers of BRCA1/2, Simard J,
Lakhal-Chaieb L. 2015. SNP set association testing for survival outcomes
in the presence of intrafamilial correlation. Genetic Epidemiology 
39:406-414.

Othus M, Li Y. 2010. A gaussian copula model for multivariate survival data.
Stat Biosci 2:154-179.
}

