% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.r2}
\alias{h2o.r2}
\title{Retrieve the R2 value}
\usage{
h2o.r2(object, valid = FALSE, ...)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{valid}{Retrieve the validation set R2 if a validation set was passed in during model build time.}

\item{\dots}{extra arguments to be passed if `object` is of type
\linkS4class{H2OModel} (e.g. train=TRUE)}
}
\description{
Retrieves the R2 value from an H2O model.
}
\examples{
\dontrun{
library(h2o)

h <- h2o.init()
fr <- as.h2o(iris)

m <- h2o.deeplearning(x=2:5,y=1,training_frame=fr)

h2o.r2(m)
}
}

