# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- coxph -------------------------- #
#' 
#' Trains a Cox Proportional Hazards Model (CoxPH) on an H2O dataset
#' 
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except event_column, start_column and stop_column are used.
#' @param event_column The name of binary data column in the training frame indicating the occurrence of an event.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame.
#' @param start_column start_column
#' @param stop_column stop_column
#' @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
#'        the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
#'        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
#'        data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
#'        well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.
#' @param offset_column Offset column. This will be added to the combination of columns before applying the link function.
#' @param ties ties Must be one of: "efron", "breslow". Defaults to efron.
#' @param init init Defaults to 0.
#' @param lre_min lre_min Defaults to 9.
#' @param iter_max iter_max Defaults to 20.
#' @export
h2o.coxph <- function(x, event_column, training_frame,
                      model_id = NULL,
                      start_column = NULL,
                      stop_column = NULL,
                      weights_column = NULL,
                      offset_column = NULL,
                      ties = c("efron", "breslow"),
                      init = 0,
                      lre_min = 9,
                      iter_max = 20
                      ) 
{

  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(event_column)) {
         x <- setdiff(col(training_frame), event_column)
     } else {
         x <- setdiff(colnames(training_frame), event_column)
     }
  }
  # Required args: training_frame
  if (missing(training_frame)) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, event_column)
  if( !missing(offset_column) && !is.null(offset_column))  args$x_ignore <- args$x_ignore[!( offset_column == args$x_ignore )]
  if( !missing(weights_column) && !is.null(weights_column)) args$x_ignore <- args$x_ignore[!( weights_column == args$x_ignore )]
  if( !missing(start_column) && !is.null(start_column)) args$x_ignore <- args$x_ignore[!( start_column == args$x_ignore )]
  if( !missing(stop_column) && !is.null(stop_column)) args$x_ignore <- args$x_ignore[!( stop_column == args$x_ignore )]
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  parms$rcall <- deparse(match.call())
  if (!missing(start_column))
    parms$start_column <- start_column
  if (!missing(stop_column))
    parms$stop_column <- stop_column
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(ties))
    parms$ties <- ties
  if (!missing(init))
    parms$init <- init
  if (!missing(lre_min))
    parms$lre_min <- lre_min
  if (!missing(iter_max))
    parms$iter_max <- iter_max
  # Error check and build model
  .h2o.modelJob('coxph', parms, h2oRestApiVersion = 3) 
}
