% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.cummax}
\alias{h2o.cummax}
\title{Return the cumulative max over a column or across a row}
\usage{
h2o.cummax(x, axis = 0)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{axis}{An int that indicates whether to do down a column (0) or across a row (1).}
}
\description{
Return the cumulative max over a column or across a row
}
\examples{
\dontrun{
library(h2o)
h2o.init()

frame <- h2o.createFrame(rows = 6, cols = 2,
                         categorical_fraction = 0.0, 
                         missing_fraction = 0.7, 
                         seed = 123)
h2o.cummax(frame, 1)
}
}
\seealso{
\code{\link[base]{cummax}} for the base R implementation.
}
