% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.pd_plot}
\alias{h2o.pd_plot}
\title{Plot partial dependence for a variable}
\usage{
h2o.pd_plot(
  object,
  newdata,
  column,
  target = NULL,
  row_index = NULL,
  max_levels = 30
)
}
\arguments{
\item{object}{An H2O model.}

\item{newdata}{An H2OFrame.  Used to generate predictions used in Partial Dependence calculations.}

\item{column}{A feature column name to inspect.  Character string.}

\item{target}{If multinomial, plot PDP just for \code{target} category.  Character string.}

\item{row_index}{Optional. Calculate Individual Conditional Expectation (ICE) for row, \code{row_index}.  Integer.}

\item{max_levels}{An integer specifying the maximum number of factor levels to show.
Defaults to 30.}
}
\value{
A ggplot2 object
}
\description{
Partial dependence plot (PDP) gives a graphical depiction of the marginal effect of a variable
on the response. The effect of a variable is measured in change in the mean response.
PDP assumes independence between the feature for which is the PDP computed and the rest.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
gbm <- h2o.gbm(y = response,
               training_frame = train)

# Create the partial dependence plot
pdp <- h2o.pd_plot(gbm, test, column = "alcohol")
print(pdp)
}
}
