% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_utilities.R
\name{res_cendist}
\alias{res_cendist}
\title{Get average distance between H3 cell centers}
\usage{
res_cendist(res = NULL, units = c("m", "km"), fast = TRUE)
}
\arguments{
\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{units}{Length unit to report in, either meters or kilometers.}

\item{fast}{Logical; whether to retrieve values from a locally stored table or
recalculate from source.}
}
\value{
Numeric; H3 cell center separation distance.
}
\description{
This function returns the average distance between the center of H3 cells
 at a given resolution.
}
\note{
This isn't in the core library but may be useful.
}
\examples{
# Return average H3 cell separation distance at each resolution in kilometers
res_cendist(res = seq(0, 15), units = 'km')

}
