% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CommonFG-DataSet.R
\docType{methods}
\name{CommonFG-DataSet}
\alias{CommonFG-DataSet}
\alias{createDataSet}
\alias{createDataSet,CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,missing-method}
\alias{createDataSet,CommonFG,character,missing,character,integer,ANY,ANY,ANY,ANY-method}
\alias{openDataSet}
\alias{openDataSet,CommonFG,character-method}
\title{Functions to Create/Open DataSets in \code{\link{CommonFG}} objects}
\usage{
createDataSet(.Object, datasetname, data, type, dimensions,
  chunksize = ChunkSize(data), maxdimensions = rep(NA_integer_,
  length(GetDimensions(data))), compression = 4L, size = -1)


  \S4method{createDataSet}{CommonFG,character,missing,character,integer,ANY,ANY,ANY,ANY}(.Object,
  datasetname, type, dimensions, chunksize, maxdimensions, compression, size)


  \S4method{createDataSet}{CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,missing}(.Object,
  datasetname, data, chunksize, maxdimensions, compression)

openDataSet(.Object, datasetname, type)

\S4method{openDataSet}{CommonFG,character}(.Object, datasetname, type)
}
\arguments{
\item{.Object}{CommonFG; S4 object of class \code{CommonFG};}

\item{datasetname}{character; HDF5 DataSet name to be used.}

\item{data}{object; Object to be stored in HDF5 file, can be either of type
vector, matrix or array.}

\item{type}{character; Character specifying data type, can be either one of:
   \describe{
       \item{double}{Double precision floating--point number.}
       \item{integer}{32--Bit integer.}
       \item{logical}{Boolean, which is mapped to 1/0 integer values.}
       \item{character}{Variable--length character strings.}
}}

\item{dimensions}{integer; Dimensions of dataset to be created.}

\item{chunksize}{integer; Chunksize to be used for dataset.}

\item{maxdimensions}{integer; Maximum dimensions used for dataset, NA is
mapped to 'unlimited'.}

\item{compression}{integer; Default GZIP compression level to be used, from
0 (no compression) to 9 (maximum compression), defaults to \code{4}.}

\item{size}{integer; Size of data type to be used, only relevant for character
strings.}
}
\description{
Although \code{\link{DataSet}} objects can implicitly be created using
subsetting operators (see \code{\link{CommonFG}}) \pkg{h5} implements more
explicit functions (used by subsetting operators under the hood) to create
and open \code{\link{DataSet}s}.
}

