% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/H5Location-Attribute.R
\docType{class}
\name{H5Location-Attribute}
\alias{H5Location}
\alias{H5Location-Attribute}
\alias{H5Location-class}
\alias{createAttribute}
\alias{createAttribute,H5Location,character-method}
\alias{h5attr}
\alias{h5attr,H5Location,character-method}
\alias{h5attr<-}
\alias{h5attr<-,H5Location,character-method}
\alias{list.attributes}
\alias{list.attributes,H5Location-method}
\alias{openAttribute}
\alias{openAttribute,H5Location,character-method}
\title{Read and Create Attributes for H5Location Objects}
\usage{
createAttribute(.Object, attributename, data, size = -1)

\S4method{createAttribute}{H5Location,character}(.Object, attributename, data,
  size = -1)

openAttribute(.Object, attributename)

\S4method{openAttribute}{H5Location,character}(.Object, attributename)

h5attr(.Object, attributename)

\S4method{h5attr}{H5Location,character}(.Object, attributename)

h5attr(.Object, attributename, ...) <- value

\S4method{h5attr}{H5Location,character}(.Object, attributename, ...) <- value

list.attributes(.Object)

\S4method{list.attributes}{H5Location}(.Object)
}
\arguments{
\item{.Object}{H5Location; S4 object of class \code{H5Location};}

\item{attributename}{character; Name of attribute to be read/created.}

\item{data}{object; Data object to be used for attribute creation,
can be either of type vector, matrix or array.}

\item{size}{numeric; Character length for fixed-length string data types.
Default value of -1 creates variable-length strings.}

\item{...}{Additional parameters passed to \code{\link{createAttribute}}.}

\item{value}{object; Object to be stored in HDF5 Attribute, can be either of
type vector, matrix or array.}
}
\description{
\code{H5Location} is the base class of \code{\link{H5File}},
\code{\link{H5Group}} and \code{\link{DataSet}} and implements common
methods to create and access attributes for inherited classes.
}
\examples{
# Write Attributes for H5File, H5Group and DataSet
file <- h5file("test.h5")
h5attr(file, "fileattrib") <- 1:10
group <- file["testgroup"]
h5attr(group, "groupattrib") <- matrix(1:9, nrow = 3)
h5attr(group, "groupattrib")
group["testdataset"] <- 1:10
dset <- group["testdataset"]
h5attr(dset, "dsetattrib") <- LETTERS[1:10]
h5close(dset)
h5close(group)
h5close(file)
file.remove("test.h5")
}
\seealso{
\code{\link{Attribute}} \code{\link{H5File}} \code{\link{H5Group}}
\code{\link{DataSet}}
}

