/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_cra_exp_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_cra_exp");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_cra_exp");
    reader.add_event(148, 133, "end", "model_cra_exp");
    return reader;
}

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
subjective_value(const T0__& alpha,
                     const T1__& beta,
                     const T2__& p,
                     const T3__& a,
                     const T4__& v, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        current_statement_begin__ = 27;
        return stan::math::promote_scalar<fun_return_scalar_t__>((pow(p,(1 + (beta * a))) * pow(v,alpha)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct subjective_value_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& alpha,
                     const T1__& beta,
                     const T2__& p,
                     const T3__& a,
                     const T4__& v, std::ostream* pstream__) const {
        return subjective_value(alpha, beta, p, a, v, pstream__);
    }
};

#include <meta_header.hpp>
 class model_cra_exp : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > prob;
    vector<vector<double> > ambig;
    vector<vector<double> > reward_var;
    vector<vector<double> > reward_fix;
public:
    model_cra_exp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_cra_exp(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_cra_exp_namespace::model_cra_exp";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 34;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("prob", "N", N);
            validate_non_negative_index("prob", "T", T);
            context__.validate_dims("data initialization", "prob", "double", context__.to_vec(N,T));
            validate_non_negative_index("prob", "N", N);
            validate_non_negative_index("prob", "T", T);
            prob = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("prob");
            pos__ = 0;
            size_t prob_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < prob_limit_1__; ++i_1__) {
                size_t prob_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < prob_limit_0__; ++i_0__) {
                    prob[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("ambig", "N", N);
            validate_non_negative_index("ambig", "T", T);
            context__.validate_dims("data initialization", "ambig", "double", context__.to_vec(N,T));
            validate_non_negative_index("ambig", "N", N);
            validate_non_negative_index("ambig", "T", T);
            ambig = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("ambig");
            pos__ = 0;
            size_t ambig_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < ambig_limit_1__; ++i_1__) {
                size_t ambig_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < ambig_limit_0__; ++i_0__) {
                    ambig[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 39;
            validate_non_negative_index("reward_var", "N", N);
            validate_non_negative_index("reward_var", "T", T);
            context__.validate_dims("data initialization", "reward_var", "double", context__.to_vec(N,T));
            validate_non_negative_index("reward_var", "N", N);
            validate_non_negative_index("reward_var", "T", T);
            reward_var = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("reward_var");
            pos__ = 0;
            size_t reward_var_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < reward_var_limit_1__; ++i_1__) {
                size_t reward_var_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < reward_var_limit_0__; ++i_0__) {
                    reward_var[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("reward_fix", "N", N);
            validate_non_negative_index("reward_fix", "T", T);
            context__.validate_dims("data initialization", "reward_fix", "double", context__.to_vec(N,T));
            validate_non_negative_index("reward_fix", "N", N);
            validate_non_negative_index("reward_fix", "T", T);
            reward_fix = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("reward_fix");
            pos__ = 0;
            size_t reward_fix_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < reward_fix_limit_1__; ++i_1__) {
                size_t reward_fix_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < reward_fix_limit_0__; ++i_0__) {
                    reward_fix[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 32;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 34;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 36;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],0);
                    check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 37;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"prob[k0__][k1__]",prob[k0__][k1__],0);
                    check_less_or_equal(function__,"prob[k0__][k1__]",prob[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 38;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"ambig[k0__][k1__]",ambig[k0__][k1__],0);
                    check_less_or_equal(function__,"ambig[k0__][k1__]",ambig[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 39;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"reward_var[k0__][k1__]",reward_var[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 40;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"reward_fix[k0__][k1__]",reward_fix[k0__][k1__],0);
                }
            }
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 46;
            validate_non_negative_index("mu_pr", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 47;
            validate_non_negative_index("sigma", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 50;
            validate_non_negative_index("alpha_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 51;
            validate_non_negative_index("beta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 52;
            validate_non_negative_index("gamma_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_cra_exp() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "3", 3);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(3));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "3", 3);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_pr", "N", N);
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        validate_non_negative_index("beta_pr", "N", N);
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        if (!(context__.contains_r("gamma_pr")))
            throw std::runtime_error("variable gamma_pr missing");
        vals_r__ = context__.vals_r("gamma_pr");
        pos__ = 0U;
        validate_non_negative_index("gamma_pr", "N", N);
        context__.validate_dims("initialization", "gamma_pr", "vector_d", context__.to_vec(N));
        vector_d gamma_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            gamma_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(gamma_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(3,lp__);
            else
                mu_pr = in__.vector_constrain(3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,3,lp__);
            else
                sigma = in__.vector_lb_constrain(0,3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pr;
            (void) alpha_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_pr = in__.vector_constrain(N,lp__);
            else
                alpha_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta_pr;
            (void) beta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pr = in__.vector_constrain(N,lp__);
            else
                beta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gamma_pr;
            (void) gamma_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_pr = in__.vector_constrain(N,lp__);
            else
                gamma_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 57;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("gamma", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gamma(static_cast<Eigen::VectorXd::Index>(N));
            (void) gamma;  // dummy to suppress unused var warning

            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 61;
            stan::math::assign(alpha, multiply(Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pr))),2));
            current_statement_begin__ = 62;
            stan::math::assign(beta, add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),beta_pr)));
            current_statement_begin__ = 63;
            stan::math::assign(gamma, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),gamma_pr))));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(gamma(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"alpha",alpha,0);
            check_less_or_equal(function__,"alpha",alpha,2);
            current_statement_begin__ = 58;
            current_statement_begin__ = 59;
            check_greater_or_equal(function__,"gamma",gamma,0);

            // model body

            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 5));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            current_statement_begin__ = 74;
            lp_accum__.add(normal_log<propto__>(gamma_pr, 0, 1));
            current_statement_begin__ = 76;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 77;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 78;
                    local_scalar_t__ u_fix;
                    (void) u_fix;  // dummy to suppress unused var warning

                    stan::math::initialize(u_fix, DUMMY_VAR__);
                    stan::math::fill(u_fix,DUMMY_VAR__);
                    current_statement_begin__ = 79;
                    local_scalar_t__ u_var;
                    (void) u_var;  // dummy to suppress unused var warning

                    stan::math::initialize(u_var, DUMMY_VAR__);
                    stan::math::fill(u_var,DUMMY_VAR__);
                    current_statement_begin__ = 80;
                    local_scalar_t__ p_var;
                    (void) p_var;  // dummy to suppress unused var warning

                    stan::math::initialize(p_var, DUMMY_VAR__);
                    stan::math::fill(p_var,DUMMY_VAR__);


                    current_statement_begin__ = 82;
                    stan::math::assign(u_fix, subjective_value(get_base1(alpha,i,"alpha",1),get_base1(beta,i,"beta",1),0.5,0,get_base1(get_base1(reward_fix,i,"reward_fix",1),t,"reward_fix",2), pstream__));
                    current_statement_begin__ = 83;
                    stan::math::assign(u_var, subjective_value(get_base1(alpha,i,"alpha",1),get_base1(beta,i,"beta",1),get_base1(get_base1(prob,i,"prob",1),t,"prob",2),get_base1(get_base1(ambig,i,"ambig",1),t,"ambig",2),get_base1(get_base1(reward_var,i,"reward_var",1),t,"reward_var",2), pstream__));
                    current_statement_begin__ = 84;
                    stan::math::assign(p_var, inv_logit((get_base1(gamma,i,"gamma",1) * (u_var - u_fix))));
                    current_statement_begin__ = 86;
                    lp_accum__.add(bernoulli_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),p_var));
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("alpha_pr");
        names__.push_back("beta_pr");
        names__.push_back("gamma_pr");
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("mu_alpha");
        names__.push_back("mu_beta");
        names__.push_back("mu_gamma");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
        names__.push_back("sv");
        names__.push_back("sv_fix");
        names__.push_back("sv_var");
        names__.push_back("p_var");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_cra_exp_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        vector_d gamma_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gamma_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 57;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("gamma", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gamma(static_cast<Eigen::VectorXd::Index>(N));
            (void) gamma;  // dummy to suppress unused var warning

            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 61;
            stan::math::assign(alpha, multiply(Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pr))),2));
            current_statement_begin__ = 62;
            stan::math::assign(beta, add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),beta_pr)));
            current_statement_begin__ = 63;
            stan::math::assign(gamma, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),gamma_pr))));

            // validate transformed parameters
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"alpha",alpha,0);
            check_less_or_equal(function__,"alpha",alpha,2);
            current_statement_begin__ = 58;
            current_statement_begin__ = 59;
            check_greater_or_equal(function__,"gamma",gamma,0);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 93;
            local_scalar_t__ mu_alpha;
            (void) mu_alpha;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha, DUMMY_VAR__);
            stan::math::fill(mu_alpha,DUMMY_VAR__);
            current_statement_begin__ = 94;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta, DUMMY_VAR__);
            stan::math::fill(mu_beta,DUMMY_VAR__);
            current_statement_begin__ = 95;
            local_scalar_t__ mu_gamma;
            (void) mu_gamma;  // dummy to suppress unused var warning

            stan::math::initialize(mu_gamma, DUMMY_VAR__);
            stan::math::fill(mu_gamma,DUMMY_VAR__);
            current_statement_begin__ = 98;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 101;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);
            current_statement_begin__ = 104;
            validate_non_negative_index("sv", "N", N);
            validate_non_negative_index("sv", "T", T);
            vector<vector<local_scalar_t__> > sv(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(sv, DUMMY_VAR__);
            stan::math::fill(sv,DUMMY_VAR__);
            current_statement_begin__ = 105;
            validate_non_negative_index("sv_fix", "N", N);
            validate_non_negative_index("sv_fix", "T", T);
            vector<vector<local_scalar_t__> > sv_fix(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(sv_fix, DUMMY_VAR__);
            stan::math::fill(sv_fix,DUMMY_VAR__);
            current_statement_begin__ = 106;
            validate_non_negative_index("sv_var", "N", N);
            validate_non_negative_index("sv_var", "T", T);
            vector<vector<local_scalar_t__> > sv_var(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(sv_var, DUMMY_VAR__);
            stan::math::fill(sv_var,DUMMY_VAR__);
            current_statement_begin__ = 107;
            validate_non_negative_index("p_var", "N", N);
            validate_non_negative_index("p_var", "T", T);
            vector<vector<local_scalar_t__> > p_var(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(p_var, DUMMY_VAR__);
            stan::math::fill(p_var,DUMMY_VAR__);


            current_statement_begin__ = 110;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 111;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 112;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 113;
                    stan::model::assign(sv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable sv");
                    current_statement_begin__ = 114;
                    stan::model::assign(sv_fix, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable sv_fix");
                    current_statement_begin__ = 115;
                    stan::model::assign(sv_var, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable sv_var");
                    current_statement_begin__ = 116;
                    stan::model::assign(p_var, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable p_var");
                }
            }
            current_statement_begin__ = 120;
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_pr,1,"mu_pr",1)) * 2));
            current_statement_begin__ = 121;
            stan::math::assign(mu_beta, get_base1(mu_pr,2,"mu_pr",1));
            current_statement_begin__ = 122;
            stan::math::assign(mu_gamma, stan::math::exp(get_base1(mu_pr,3,"mu_pr",1)));

            current_statement_begin__ = 125;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 127;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 129;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 130;
                    local_scalar_t__ u_fix;
                    (void) u_fix;  // dummy to suppress unused var warning

                    stan::math::initialize(u_fix, DUMMY_VAR__);
                    stan::math::fill(u_fix,DUMMY_VAR__);
                    current_statement_begin__ = 131;
                    local_scalar_t__ u_var;
                    (void) u_var;  // dummy to suppress unused var warning

                    stan::math::initialize(u_var, DUMMY_VAR__);
                    stan::math::fill(u_var,DUMMY_VAR__);


                    current_statement_begin__ = 133;
                    stan::math::assign(u_fix, subjective_value(get_base1(alpha,i,"alpha",1),get_base1(beta,i,"beta",1),0.5,0,get_base1(get_base1(reward_fix,i,"reward_fix",1),t,"reward_fix",2), pstream__));
                    current_statement_begin__ = 134;
                    stan::math::assign(u_var, subjective_value(get_base1(alpha,i,"alpha",1),get_base1(beta,i,"beta",1),get_base1(get_base1(prob,i,"prob",1),t,"prob",2),get_base1(get_base1(ambig,i,"ambig",1),t,"ambig",2),get_base1(get_base1(reward_var,i,"reward_var",1),t,"reward_var",2), pstream__));
                    current_statement_begin__ = 135;
                    stan::model::assign(p_var, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                inv_logit((get_base1(gamma,i,"gamma",1) * (u_var - u_fix))), 
                                "assigning variable p_var");
                    current_statement_begin__ = 137;
                    stan::model::assign(sv_fix, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                u_fix, 
                                "assigning variable sv_fix");
                    current_statement_begin__ = 138;
                    stan::model::assign(sv_var, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                u_var, 
                                "assigning variable sv_var");
                    current_statement_begin__ = 139;
                    stan::model::assign(sv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                (logical_eq(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),1) ? u_var : u_fix ), 
                                "assigning variable sv");
                    current_statement_begin__ = 141;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),get_base1(get_base1(p_var,i,"p_var",1),t,"p_var",2))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 142;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(get_base1(get_base1(p_var,i,"p_var",1),t,"p_var",2), base_rng__), 
                                "assigning variable y_pred");
                    }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 93;
            check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
            check_less_or_equal(function__,"mu_alpha",mu_alpha,2);
            current_statement_begin__ = 94;
            current_statement_begin__ = 95;
            check_greater_or_equal(function__,"mu_gamma",mu_gamma,0);
            current_statement_begin__ = 98;
            current_statement_begin__ = 101;
            current_statement_begin__ = 104;
            current_statement_begin__ = 105;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"p_var[k0__][k1__]",p_var[k0__][k1__],0);
                    check_less_or_equal(function__,"p_var[k0__][k1__]",p_var[k0__][k1__],1);
                }
            }

            // write generated quantities
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_beta);
        vars__.push_back(mu_gamma);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(sv[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(sv_fix[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(sv_var[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(p_var[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_cra_exp";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gamma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv_fix" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv_var" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p_var" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gamma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv_fix" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sv_var" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p_var" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_cra_exp_namespace::model_cra_exp stan_model;


#endif
