% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInd.R
\name{plotInd}
\alias{plotInd}
\title{Plots individual posterior distributions, using the stan_plot function of the rstan package}
\usage{
plotInd(obj = NULL, pars, show_density = T, ...)
}
\arguments{
\item{obj}{An output of the hBayesDM. Its class should be 'hBayesDM'.}

\item{pars}{(from stan_plot's help file) Character vector of parameter names. If unspecified, show all user-defined parameters or the first 10 (if there are more than 10)}

\item{show_density}{T(rue) or F(alse). Show the density (T) or not (F)?}

\item{...}{(from stan_plot's help file) Optional additional named arguments passed to stan_plot, which will be passed to geoms. See stan_plot's help file.}
}
\description{
Plots individual posterior distributions, using the stan_plot function of the rstan package
}
\examples{
\dontrun{
# Run a model
output <- dd_hyperbolic("example", 2000, 1000, 3, 3)

# Plot the hyper parameters ('k' and 'beta')
plot(output)

# Plot individual 'k' (discounting rate) parameters
plotInd(output, "k")

# Plot individual 'beta' (inverse temperature) parameters
plotInd(output, "beta")

# Plot individual 'beta' parameters but don't show density
plotInd(output, "beta", show_density = F)
}
}
