% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_online.R
\name{analysis_online}
\alias{analysis_online}
\title{analysis_online}
\usage{
analysis_online(L, Time, t1, t2, beta, kappa, mul, cg_col, evals_id, rundir,
  cg.ylim, type = "", csw = 0, musigma = 0, mudelta = 0, muh = 0,
  addon = "", skip = 0, rectangle = TRUE, plaquette = TRUE,
  dH = TRUE, acc = TRUE, trajtime = TRUE, omeas = TRUE, plotsize = 5,
  debug = FALSE, trajlabel = FALSE, title = FALSE, pl = FALSE,
  method = "uwerr", fit.routine = "optim", oldnorm = FALSE, S = 1.5,
  stat_skip = 0, omeas.samples = 1, omeas.stride = 1, omeas.avg = 1,
  omeas.stepsize = 1, evals.stepsize = 1, boot.R = 1500, boot.l = 2,
  outname_suffix = "", verbose = FALSE)
}
\arguments{
\item{L}{integer. spatial lattice extent}

\item{Time}{integer. temporal lattice extent}

\item{t1}{integer. initial time of fit range}

\item{t2}{integer. end time of fit range}

\item{beta}{numeric. inverse squared gauge coupling}

\item{kappa}{numeric. hopping parameter}

\item{mul}{numeric. light sea twisted quark mass}

\item{cg_col}{integer. column of CG iteration counts from \code{output.data} to use}

\item{evals_id}{Integer. Monomial ID of the monomial for which eigenvalues are measured.
Function will attempt to open \verb{monomial-\%02d.data}.}

\item{rundir}{string. run directory. If not specified, run directory will
be constructed automatically. See \link{construct_onlinemeas_rundir} for
details.}

\item{cg.ylim}{numeric. y-limits for CG iteration counts}

\item{type}{string. Type specifier for the gauge action, this might be 'iwa' for Iwasaki,
for example.}

\item{csw}{numeric. clover coefficient}

\item{musigma}{numeric. average 1+1 sea twisted quark mass}

\item{mudelta}{numeric. splitting 1+1 sea twisted quark mass}

\item{muh}{numeric. "heavy" twisted mass in the case of a \code{n_f=2+2} run}

\item{addon}{string. addon to output filenames}

\item{skip}{integer. number of initial measurements to skip in analysis}

\item{rectangle}{boolean. If true, rectangle plaquettes are analysed}

\item{plaquette}{boolean. If true, square plaquettes are analysed}

\item{dH}{boolean. If true, delta H is analysed}

\item{acc}{boolean. If true, the acceptance rate is analysed}

\item{trajtime}{boolean. If true, the time per trajectory is analysed}

\item{omeas}{boolean. If true, online measurements are analysed (\verb{onlinemeas.\%06d})}

\item{plotsize}{numeric. size of plots being generated}

\item{debug}{boolean. provide debug information}

\item{trajlabel}{boolean or string. If not \code{FALSE}, use as trajectory labels}

\item{title}{bolean or string. If not \code{FALSE}, use as main title of plots}

\item{pl}{boolean. If set to \code{TRUE} plots will be generated}

\item{method}{string. method to compute errors, can be "uwerr", "boot" or "all"}

\item{fit.routine}{string. minimisation routine for chisq, can be "optim"}

\item{oldnorm}{boolean. If \code{TRUE}, the function assumes that the \verb{onlinemeas.\%06d} are
in old tmLQCD normalisation.}

\item{S}{numeric. \code{S} parameter of \link{uwerr}}

\item{stat_skip}{integer. By passing this parameter, the various timeseries plots
will include \code{stat_skip} measurements,
but these will be skipped in the corresponding statistical analysis.
This maybe useful, for example, to visualise thermalisation.}

\item{omeas.samples}{integer. number of stochastic samples per online measurement}

\item{omeas.stride}{integer. stride length in the reading of online measurements}

\item{omeas.avg}{integer. Block average over this many subsequent measurements.}

\item{omeas.stepsize}{integer. Number of trajectories between online measurements. Autocorrelation
times of online measurement data will be scaled by this factor.}

\item{evals.stepsize}{integer. Numer of trajectories between (strange-charm Dirac opertoar) eigenvalue measurements.
Autocorrelation times of eigenvalues will be scaled by this factor.}

\item{boot.R}{integer. number of bootstrap samples to use in bootstrap-based parts of analysis.}

\item{boot.l}{integer. bootstrap block size}

\item{outname_suffix}{string. suffix for output files}

\item{verbose}{boolean. If \code{TRUE}, function produces verbose output.
#'}
}
\value{
a list is returned with all the accumulated results. Moreover, a
PDF file with statistics and analytics is created and the results
are written into .Rdata files. On the one hand, the result of the
call to the \link{onlinemeas} function is written to
\verb{onlineout.\%s.Rdata}, where \verb{\%s} is replaced with a label
built from meta information based on the arguments above.
On the other hand, summary data across many calls of this
function is silently accumulated in the file
\code{omeas.summary.Rdata} which contains the named list 'resultsum' with
element names based on \code{rundir}.
}
\description{
\code{analysis_online} is a function to analyse the online measurements
and output files of the tmLQCD software, see references. The function
operates on a subdirectory either passed via \code{rundir} or automatically
constructed from the various function arguments. Depending on which
parts of the analysis are requested, this subdirectory is expected
to contain \verb{onlinemeas.\%06d} files with online correlator measurements,
\code{output.data} containing the plaquette and energy violation, amongst others
and \verb{monomial-\%02d.data} with measurements of the extremal eigenvalues of the
}
\references{
K. Jansen and C. Urbach, Comput.Phys.Commun. 180 (2009) 2717-2738
}
