% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readutils.R
\name{readbinarysamples}
\alias{readbinarysamples}
\title{Read binary correlation function by sample}
\usage{
readbinarysamples(files, Time = 48, nosamples = 2, endian = "little",
  excludelist = c(""), sym = TRUE, path = "", ftype = double())
}
\arguments{
\item{files}{character vector. Paths to the file to read. As \code{path} is
prepended to each element, one can also just pass the filenames here.}

\item{Time}{numeric. Time extent.}

\item{nosamples}{number of samples}

\item{endian}{character, either \code{little} or \code{big}.}

\item{excludelist}{character vector. Elements in \code{files} that are specified
in \code{excludelist} are skipped. The caller could also just pass
\code{setdiff(files, excludelist)}.}

\item{sym}{logical. Whether the read data shall be symmetrized in the end.}

\item{path}{character. Path that is prefixed to each of the paths given in
\code{files}.}

\item{ftype}{numeric type. As the data is read in binary this type has to
match exactly the one in the file.}
}
\value{
Returns a \link{list} of \code{cf} objects.
}
\description{
Read binary correlation functions sample by sample, return as a list of
length \code{nosamples} where increasing indices refer to averaging over
increasing numbers of samples.
}
