% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{plot.cf}
\alias{plot.cf}
\title{Plot a correlation function}
\usage{
\method{plot}{cf}(x, neg.vec = rep(1, times = length(x$cf0)), rep = FALSE,
  ...)
}
\arguments{
\item{x}{\code{cf_boot} object}

\item{neg.vec}{Numeric vector of length \code{cf$cf0}. This allows switching the
sign for certain time slices or observables such that displaying in
log-scale is sensible.}

\item{rep}{See \code{\link{plotwitherror}}.}

\item{...}{Graphical parameter to be passed on to \link{plotwitherror}}
}
\value{
Invisibly returns a data.frame with named columns \code{t} containing the (physical)
t-values, \code{CF} the mean values of the correlation function and \code{Err} its standard error.
}
\description{
Plot a correlation function
}
