% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotNodes}
\alias{plotNodes}
\title{plotNodes}
\usage{
plotNodes(img, thinned, nodeList, nodeSize = 3, nodeColor = "red")
}
\arguments{
\item{img}{Full image matrix, unthinned.}

\item{thinned}{Thinned image matrix}

\item{nodeList}{Nodelist returned from getNodes.}

\item{nodeSize}{Size of triangles printed. 3 by default. Move down to 2 or 1 for small text images.}

\item{nodeColor}{Which color the nodes should be}
}
\value{
Plot of full and thinned image with vertices overlaid.
}
\description{
This function returns a plot with the full image plotted in light gray and the skeleton printed in black, with red triangles over the vertices.
Also called from plotPath, which is a more useful function, in general.
}
\examples{
\dontrun{
twoSent_document = list()
twoSent_document$image = twoSent
twoSent_document$thin = thinImage(twoSent_document$image)
twoSent_processList = processHandwriting(twoSent_document$thin, dim(twoSent_document$image))

twoSent_document$nodes = twoSent_processList$nodes
twoSent_document$breaks = twoSent_processList$breakPoints
plotNodes(twoSent_document$image, twoSent_document$thin, twoSent_document$nodes)
plotNodes(twoSent_document$image, twoSent_document$thin, twoSent_document$breaks)
}
}
