% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReformatDataframe.R
\name{unifyDataframe}
\alias{unifyDataframe}
\title{Reformat dataframe with the all modifiers simultaneously (colNames, rowNames and dtypes)}
\usage{
unifyDataframe(
  rawDataFrame,
  rawRowSep = "..",
  rowSep = "_",
  rawColSep = "..",
  colSep = "_",
  changeDtype = TRUE
)
}
\arguments{
\item{rawDataFrame}{raw data.frame}

\item{rawRowSep}{raw separation deliminator of row names in raw data.frame}

\item{rowSep}{the new separation deliminator of row names}

\item{rawColSep}{raw separation deliminator of col names in raw data.frame}

\item{colSep}{the new separation deliminator of col names}

\item{changeDtype}{if change the dtypes of cols}
}
\value{
A modified data.frame with applied to above all modifiers
}
\description{
Reformat dataframe with the all modifiers simultaneously (colNames, rowNames and dtypes)
}
\examples{
library(handyFunctions)
data(people)
unifyDataframe(people,rawColSep = "[.][.]")

}
