% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/election_candidates.R
\name{election_candidates}
\alias{election_candidates}
\alias{hansard_election_candidates}
\title{Returns the name of all candidates standing in an election.}
\usage{
election_candidates(ID = NULL, constit_details = FALSE, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_election_candidates(ID = NULL, constit_details = FALSE,
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{ID}{Accepts an ID for a general or by-election from the 2010 general election onwards, and returns the results. If NULL, returns all available election results. Defaults to NULL.}

\item{constit_details}{If TRUE, returns additional details on each constituency, including its GSS (Government Statistical Service) code. Defaults to FALSE.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with the names of each candidate standing in each constituency in an election or elections. If there are multiple candidates from the same party, or multiple independent candidates, their names are combined into a list.
}
\description{
Returns the name of all candidates standing in an election.
}
\examples{
\dontrun{

x <- election_candidates(ID=382037)

y <- election_candidates()

z <- election_candidates(constit_details = TRUE)


}

}
\seealso{
\code{\link{elections}}

\code{\link{election_results}}
}
