% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SNP_time_series.R
\docType{methods}
\name{reconstruct_hb,SNP_time_series-method}
\alias{reconstruct_hb}
\alias{reconstruct_hb,SNP_time_series-method}
\alias{reconstruct_hb.SNP_time_series}
\title{Reconstruction of haplotype-blocks}
\usage{
\S4method{reconstruct_hb}{SNP_time_series}(object, chrom, min.cl.size = 4,
  min.cl.cor = 0.8, min.inter = 2, single.win = F, transf = T,
  scaleSNP = T, pos.cor = F, clusterM = "avLink", eps = 0.3)
}
\arguments{
\item{object}{object of the class SNP_time_series data}

\item{chrom}{a string specifying the name of the chromosome present in the object for which
haplotype-block should be reconstructed}

\item{min.cl.size}{numeric specifying the minimum number of correlated markers in a window for 
haplotype-block reconstruction}

\item{min.cl.cor}{numeric specifying the correlation between marker SNPs required using average
linkage clustering for markers to be assembled in one cluster}

\item{min.inter}{numeric specifying the minimum number of markers in two clusters of overlapping 
windows required to be identical for cluster elongation across windows to build haplotype-blocks}

\item{single.win}{boolean specifying that are supported by only a cluster in one window are 
also included in the markers of reconstructed blocks. If FALSE only hbrs are returned that span
at least two windows and only markers being present in the intersection between overlapping
windows are included.}

\item{transf}{boolean indicating if frequency data should be square root transformed 
prior to calaculation pariwise correlations with Pearson's correlation coefficient.}

\item{scaleSNP}{boolean indicating whether time series allele frequency data
for each SNP should be scaled (scaling to a mean of zero and standard deviation of 1.}

\item{pos.cor}{boolean indicating if negative correlations should be set to zero
prior to clustering.}

\item{clusterM}{indicating the clustering method, choose from: "avLink" (average linkage clustering)
and "\href{https://CRAN.R-project.org/package=dbscan}{dbscan}".}

\item{eps}{size of the epsilon neighborhood when clustering with \href{https://CRAN.R-project.org/package=dbscan}{dbscan}.
For details please refer to the dbscan package.}
}
\value{
an object of the class \code{\link{hbr}}
}
\description{
This function reconstructs haplotype-blocks from a SNP_time_series object based on correlated allele
frequency changes aacross time points and replicates
}
\details{
This function reconstructs haplotype-blocks via markers that show correlated frequency changes across
multiple time-points and replicates. In a sliding window based approach SNPs are clustered by average linkage
clustering based on correlations of their frequencies across time points and replicates. Clusters are build for
each window using the parameters \code{min.cl.size} and \code{min.cl.cor}. Clustered in overlaping windows (window size/2) are
elongated to haplotype-blocks if two adjacent clusters have \code{min.inter} identical markers./n
Reconstructed haplotype blocks were constructed from at least two overlapping windows and consist of markers that
are present in two overlaping window clusters.
}
\author{
Susanne U. Franssen
}
\references{
Franssen et al. 2016, \href{http://mbe.oxfordjournals.org/content/early/2016/10/03/molbev.msw210.abstract}{Reconstruction of haplotype-blocks
selected during experimental evolution}, \href{http://mbe.oxfordjournals.org/}{MBE}
}
\seealso{
\code{\link{ex_dat}} \code{\link{initialize_SNP_time_series}} \code{\link{SNP_time_series}}
}

