% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercept.R
\name{add_intercept_column}
\alias{add_intercept_column}
\title{Add an intercept column to \code{data}}
\usage{
add_intercept_column(data, name = "(Intercept)")
}
\arguments{
\item{data}{A data frame or matrix.}

\item{name}{The name for the intercept column. Defaults to \code{"(Intercept)"},
which is the same name that \code{\link[stats:lm]{stats::lm()}} uses.}
}
\value{
\code{data} with an intercept column.
}
\description{
This function adds an integer column of \code{1}'s to \code{data}.
}
\details{
If a column named \code{name} already exists in \code{data}, then \code{data} is returned
unchanged and a warning is issued.
}
\examples{
add_intercept_column(mtcars)

add_intercept_column(mtcars, "intercept")

add_intercept_column(as.matrix(mtcars))
}
