% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hawkes.R
\name{compensator}
\alias{compensator}
\title{Compensator of a Hawkes process}
\usage{
compensator(x, t, fun = NULL, repr = NULL, family = NULL, M = NULL, ...)
}
\arguments{
\item{x}{A non-negative numeric vector, sorted in ascending order; or an object of class "hawkes" output by function \code{hawkes}.}

\item{t}{A non-negative numeric value or vector, at which the intensity should be computed.}

\item{fun}{(default = TRUE) A non-negative numeric function or value - intensity (function) of the immigrant process.}

\item{repr}{(default = NULL) A non-negative numeric value - mean number of offsprings.}

\item{family}{(default = NULL) A character string "name" naming a distribution with corresponding distribution function \code{dname}, or directly the distribution function.}

\item{M}{(default = NULL) A non-negative numeric value - upper bound on \code{fun}(ignored if \code{fun} is a numeric value).}

\item{...}{Additional arguments passed on to the random generation function \code{dname}.}
}
\value{
The compensator at time t.
}
\description{
Outputs the compensator (integrated intensity) of a Hawkes process.
}
\examples{
# Simulate an exponential Hawkes process with baseline intensity 1,
# reproduction mean 0.5 and exponential fertility distribution with rate 2.
x <- hawkes(10, fun=1, repr=0.5, family="exp", rate=2)
compensator(x, 0:10)
# Compensator with a different set of parameters
compensator(x, 0:10, repr=0.8, rate=3)
# Compensator with a different distribution function
compensator(x, 0:10, family="chisq", df=2)
# Simulate a Hawkes process with baseline intensity function 1 + sin(x),
# reproduction mean 0.5 and custom [0,1]-triangular fertility function.
x <- hawkes(10, fun=function(y) {1+sin(y)}, M=2, repr=0.5,
            family=function(n) {1 - sqrt(1 - runif(n))})
compensator(x, 0:10, family=function(y) ifelse(y>0 & y<1, 2-2*y, 0))
}
