% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{COVID19}
\alias{COVID19}
\title{COVID-19 ordinal scale dataset (full report).}
\format{
a data frame with 1062 rows and 2 variables:
\describe{
\item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
\item{TRTP}{treatment values, A Active or P Placebo, character}
}
}
\source{
\url{doi:10.1056/NEJMoa2007764}
}
\usage{
COVID19
}
\description{
A dataset containing dataset with COVID-19 ordinal scale outcomes for 1062 patients.
}
\examples{
#Frequencies
table(COVID19)
mosaicplot(table(COVID19), col = c(1, 8, 6, 2, 4, 5, 3, 7), 
xlab = "Treatment", ylab = "Ordinal Scale", main = "COVID-19 ordinal scale")
# Convert to an hce object
COVID19HCE <- hce(GROUP = COVID19$GROUP, TRTP = COVID19$TRTP)
# Summary wins, losses, and ties with win odds
summaryWO(COVID19HCE)
}
\keyword{datasets}
