% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simORD.R
\name{simORD}
\alias{simORD}
\title{Simulate ordinal variables for two treatment groups using categorization of beta distributions}
\usage{
simORD(n, n0 = n, M, alpha1 = 8, beta1 = 7, alpha0 = 5, beta0 = 5)
}
\arguments{
\item{n}{sample size in the active treatment group.}

\item{n0}{sample size in the placebo group.}

\item{M}{number of ordinal values to be simulated.}

\item{alpha1}{shape1 parameter for the beta distribution in the active group.}

\item{beta1}{shape2 parameter for the beta distribution in the active group.}

\item{alpha0}{shape1 parameter for the beta distribution in the placebo group.}

\item{beta0}{shape2 parameter for the beta distribution in the placebo group.}
}
\value{
a data frame containing the following columns:
\itemize{
\item ID subject identifier.
\item TRTP planned treatment group - "A" for active, "P" for Placebo.
\item GROUPN ordinal values. The number of unique values is specified by the variable \code{M0}.
\item tau the theoretical win odds.
\item theta the theoretical win probability.
}
}
\description{
Simulate ordinal variables for two treatment groups using categorization of beta distributions
}
\examples{
# Example 1
set.seed(2024)
d <- simORD(n = 100, n0 = 50, M = 2)
d_hce <- hce(GROUP = d$GROUPN, TRTP = d$TRTP)
calcWO(d_hce)
### compare with the theoretical values of the continuous distributions 
c(tau = unique(d$tau), theta = unique(d$theta))
# Example 2 - Convergence of the win odds to its theoretical value
set.seed(2024)
N <- NULL
size <- c(seq(10, 500, 1))
for(i in size){
  d <- simORD(n = i, M = 2)
  d_hce <- hce(GROUP = d$GROUPN, TRTP = d$TRTP)
  TAU <- calcWO(d_hce)
  D <- data.frame(WO = TAU$WO, n = i, tau = unique(d$tau))
  N <- rbind(N, D)
}
plot(N$n, N$WO, log = "y", ylim = c(0.5, 2), ylab = "Win Odds", xlab = "Sample size", type = "l")
lines(N$n, N$tau, col = "darkgreen", lty = 2, lwd = 2)
abline(h = 1, lty = 4, col = "red")
legend("bottomright", legend = c("Null", "Theoretical Win Odds", "Win Odds Estimate"), 
lty = c(4, 2, 1), col = c("darkgreen", "red", "black"))
title("Convergence of the win odds to its theoretical value")
}
\seealso{
\code{\link[=simHCE]{simHCE()}}, \code{\link[=simADHCE]{simADHCE()}} for simulating \code{hce} objects.
}
