% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbs.R
\name{sbs.thr}
\alias{sbs.thr}
\title{Bootstrapping for threshold selection in SBS algorithm}
\usage{
sbs.thr(z, interval = c(1, dim(z)[2]), cp.type = 1, do.clean.cp = TRUE,
  scales = NULL, diag = FALSE, sgn = NULL, B = 1000, q = 0.01,
  do.parallel = 4)
}
\arguments{
\item{z}{input data matrix, with each row representing the component time series}

\item{interval}{a vector of two containing the start and the end points of the interval from which the bootstrap test statistics are to be calculated}

\item{cp.type, scales, diag, B, q, do.parallel}{see \code{\link{sbs.alg}}}

\item{do.clean.cp}{if \code{do.clean.cp = TRUE} pre-change-point cleaning is performed}

\item{sgn}{if \code{diag = FALSE}, wavelet transformations of the cross-covariances are computed with the matching signs}
}
\value{
if \code{cp.type = 1}, a vector of length \code{nrow(z)}, each containing the threshold applied to the CUSUM statistics from the corresponding coordinate of \code{z}
if \code{cp.type = 2}, a vector of length \code{length(scales)*nrow(z)} (when \code{diag = TRUE}) or \code{length(scales)*nrow(z)*(nrow(z)+1)/2} (when \code{diag = FALSE}), each containing the threshold applied to the CUSUM statistics of the corresponding wavelet transformation of \code{z}
}
\description{
Generate thresholds for SBS algorithm via bootstrapping
}
