// (c) The HDF Group
#ifndef H5Iprivate_H
#define H5Iprivate_H
#include "H5Ipublic.h"
#include "H5Idevelop.h"
#include "H5private.h"
#include "H5VLprivate.h"
#define H5I_IS_LIB_TYPE(type) (type > 0 && type < H5I_NTYPES)
#define H5I_CLASS_IS_APPLICATION 0x01
typedef struct H5I_class_t {
    H5I_type_t type;
    unsigned   flags;
    unsigned   reserved;
    H5I_free_t free_func;
} H5I_class_t;
H5_DLL herr_t     H5I_register_type(const H5I_class_t *cls);
H5_DLL int64_t    H5I_nmembers(H5I_type_t type);
H5_DLL herr_t     H5I_clear_type(H5I_type_t type, bool force, bool app_ref);
H5_DLL H5I_type_t H5I_get_type(hid_t id);
H5_DLL herr_t     H5I_iterate(H5I_type_t type, H5I_search_func_t func, void *udata, bool app_ref);
H5_DLL int        H5I_get_ref(hid_t id, bool app_ref);
H5_DLL int        H5I_inc_ref(hid_t id, bool app_ref);
H5_DLL int        H5I_dec_ref(hid_t id);
H5_DLL int        H5I_dec_app_ref(hid_t id);
H5_DLL int        H5I_dec_app_ref_async(hid_t id, void **token);
H5_DLL int        H5I_dec_app_ref_always_close(hid_t id);
H5_DLL int        H5I_dec_app_ref_always_close_async(hid_t id, void **token);
H5_DLL int        H5I_dec_type_ref(H5I_type_t type);
H5_DLL herr_t     H5I_find_id(const void *object, H5I_type_t type, hid_t *id);
H5_DLL void  *H5I_object(hid_t id);
H5_DLL void  *H5I_object_verify(hid_t id, H5I_type_t type);
H5_DLL void  *H5I_remove(hid_t id);
H5_DLL void  *H5I_subst(hid_t id, const void *new_object);
H5_DLL htri_t H5I_is_file_object(hid_t id);
H5_DLL hid_t  H5I_register(H5I_type_t type, const void *object, bool app_ref);
H5_DLL herr_t H5I_register_using_existing_id(H5I_type_t type, void *object, bool app_ref, hid_t existing_id);
H5_DLL herr_t H5I_dump_ids_for_type(H5I_type_t type);
#endif
