% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5Write}
\alias{h5Write}
\alias{h5Write.default}
\alias{h5Write.array}
\alias{h5Write.factor}
\alias{h5Write.data.frame}
\alias{h5Write.dgCMatrix}
\alias{h5Write.dgRMatrix}
\alias{h5Write.list}
\title{Write an R object to HDF5 file}
\usage{
h5Write(x, file, name, ...)

\method{h5Write}{default}(x, file, name, overwrite = FALSE, gzip_level = 6, ...)

\method{h5Write}{array}(
  x,
  file,
  name,
  overwrite = FALSE,
  transpose = FALSE,
  block_size = 5000L,
  gzip_level = 6,
  ...
)

\method{h5Write}{factor}(x, file, name, overwrite = FALSE, ordered = TRUE, gzip_level = 6, ...)

\method{h5Write}{data.frame}(x, file, name, overwrite = FALSE, gzip_level = 6, ...)

\method{h5Write}{dgCMatrix}(
  x,
  file,
  name,
  overwrite = FALSE,
  transpose = FALSE,
  add.shape = FALSE,
  dimnames = list(),
  gzip_level = 6,
  ...
)

\method{h5Write}{dgRMatrix}(
  x,
  file,
  name,
  overwrite = FALSE,
  transpose = FALSE,
  add.shape = FALSE,
  dimnames = list(),
  gzip_level = 6,
  ...
)

\method{h5Write}{list}(x, file, name, overwrite = FALSE, gzip_level = 6, ...)
}
\arguments{
\item{x}{An R object to be written}

\item{file}{An existing HDF5 file}

\item{name}{Name of the HDF5 link to be written into}

\item{...}{Arguments passed to other methods.}

\item{overwrite}{Whether or not to overwrite the existing HDF5 link.}

\item{gzip_level}{Enable zipping at the level given here.}

\item{transpose}{Whether or not to transpose the input matrix. Only works for 
a 2-dimension array-like object.}

\item{block_size}{Default size for number of columns when \code{transpose} 
is \code{TRUE}.}

\item{ordered}{When writing a factor, whether or not the categories are 
ordered.}

\item{add.shape}{When writing a CSC- or CSR-matrix, whether or not to also 
write the number of dimensions into an HDF5 dataset.}

\item{dimnames}{When writing a CSC- or CSR-matrix, whether or not to also 
write the dimension names.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Methods to write an R object to an HDF5 file.
}
\details{
By default, \code{h5Write} will try to transform any S4 object \code{x} into 
combination of base R objects using \code{\link{h5Prep}} before writting it.
}
\examples{
\donttest{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
tmp.file <- tempfile(fileext = ".h5")
h5CreateFile(tmp.file)

# vector -----------------------
x <- h5Read(file, "/raw/X/data")
h5Write(x, tmp.file, "raw/X/data")
x2 <- h5Read(tmp.file, "raw/X/data")
stopifnot(identical(x, x2))
}

\donttest{
# matrix -----------------------
x <- h5Read(file, "X")
h5Write(x, tmp.file, "X")
x2 <- h5Read(tmp.file, "X")
stopifnot(identical(x, x2))

h5Write(x, tmp.file, "X2", transpose = TRUE)
x2 <- h5Read(tmp.file, "X2")
stopifnot(identical(t(x), x2))
}

\donttest{
# data.frame -----------------------
x <- h5Read(file, "obs")
h5Write(x, tmp.file, "obs")
x2 <- h5Read(tmp.file, "obs")
stopifnot(identical(x, x2))

x <- h5Read(file, "raw/var") # data.frame with empty column
h5Write(x, tmp.file, "raw/var")
x2 <- h5Read(tmp.file, "raw/var")
stopifnot(identical(x, x2))
}

\donttest{
# dgCMatrix -----------------------
x <- h5Read(file, "raw/X")
h5Write(x, tmp.file, "raw/X", overwrite = TRUE)
x2 <- h5Read(tmp.file, "raw/X")
stopifnot(identical(x, x2))
}

\donttest{
# list -----------------------
x <- h5Read(file)
h5Write(x, tmp.file, name = NULL, overwrite = TRUE)
x2 <- h5Read(tmp.file)
stopifnot(identical(x, x2))
}

}
\references{
\url{https://anndata.readthedocs.io/en/latest/fileformat-prose.html}
}
