% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rlassologitEffect.R
\name{rlassologitEffects}
\alias{rlassologitEffect}
\alias{rlassologitEffects}
\title{rigorous Lasso for Logistic Models: Inference}
\usage{
rlassologitEffects(x, y, index = c(1:ncol(x)), I3 = NULL, ...)

rlassologitEffect(x, y, d, I3 = NULL)
}
\arguments{
\item{x}{matrix of regressor variables serving as controls and potential
treatments.  For \code{rlassologitEffect} it contains only controls, for \code{rlassologitEffects} both controls and potential treatments. For  \code{rlassologitEffects} it must have at least two columns.}

\item{y}{outcome variable}

\item{index}{vector of integers, logical or names indicating the position (column) or name of
variables of x which should be used as treatment variables.}

\item{I3}{logical vector with same length as the number of controls;
indicates if variables (TRUE) should be included in any case.}

\item{d}{variable for which inference is conducted (treatment variable)}

\item{\dots}{additional parameters}
}
\value{
The function returns an object of class \code{rlassologitEffects} with the following entries: \item{coefficients}{estimated
value of the coefficients} \item{se}{standard errors}
\item{t}{t-statistics} \item{pval}{p-values} \item{samplesize}{sample size of the data set} \item{I}{index of variables of the union of the lasso regressions}
}
\description{
The function estimates (low-dimensional) target coefficients in a high-dimensional logistic model.
}
\details{
The functions estimates (low-dimensional) target coefficients in a high-dimensional logistic model.
An application is e.g. estimation of a treatment effect \eqn{\alpha_0} in a
setting of high-dimensional controls. The function is a wrap function for \code{rlassologitEffect} which does inference for only one variable (d).
}
\references{
A. Belloni, V. Chernozhukov, Y. Wei (2013). Honest confidence regions for a regression parameter in logistic regression with a loarge number of controls.
cemmap working paper CWP67/13.
}
\keyword{Estimation}
\keyword{Inference}
\keyword{Lasso}
\keyword{Logistic}

