% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoIV.R
\name{rlassoIV}
\alias{rlassoIV}
\alias{rlassoIV.default}
\alias{rlassoIV.formula}
\alias{rlassoIVmult}
\title{Post-Selection and Post-Regularization Inference in Linear Models with Many
Controls and Instruments}
\usage{
rlassoIV(x, ...)

\method{rlassoIV}{default}(x, d, y, z, select.Z = TRUE, select.X = TRUE,
  post = TRUE, ...)

\method{rlassoIV}{formula}(formula, data, select.Z = TRUE, select.X = TRUE,
  post = TRUE, ...)

rlassoIVmult(x, d, y, z, select.Z = TRUE, select.X = TRUE, ...)
}
\arguments{
\item{x}{matrix of exogenous variables}

\item{d}{endogenous variable}

\item{y}{outcome / dependent variable (vector or matrix)}

\item{z}{matrix of instrumental variables}

\item{select.Z}{logical, indicating selection on the instruments.}

\item{select.X}{logical, indicating selection on the exogenous variables.}

\item{post}{logical, wheter post-Lasso should be conducted (default=\code{TRUE})}

\item{formula}{An object of class \code{Formula} of the form " y ~ x + d | x + z" with y the outcome variable,
d endogenous variable, z instrumental variables, and x exogenous variables.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which \code{rlassoIV} is called.}

\item{\dots}{arguments passed to the function \code{rlasso}}
}
\value{
an object of class \code{rlassoIV} containing at least the following
components: \item{coefficients}{estimated parameter value}
\item{se}{variance-covariance matrix}
}
\description{
The function estimates a treatment effect in a setting with very many
controls and very many instruments (even larger than the sample size).
}
\details{
The implementation for selection on x and z follows the procedure described in Chernozhukov et al.
(2015) and is built on 'triple selection' to achieve an orthogonal moment
function. The function returns an object of S3 class \code{rlassoIV}.
Moreover, it is wrap function for the case that selection should be done only with the instruments Z (\code{rlassoIVselectZ}) or with 
the control variables X (\code{rlassoIVselectX}) or without selection (\code{tsls}). Exogenous variables 
\code{x} are automatically used as instruments and added to the
instrument set \code{z}.
}
\examples{
\dontrun{
data(EminentDomain)
z <- EminentDomain$logGDP$z # instruments
x <- EminentDomain$logGDP$x # exogenous variables
y <- EminentDomain$logGDP$y # outcome varialbe
d <- EminentDomain$logGDP$d # treatment / endogenous variable
lasso.IV.Z = rlassoIV(x=x, d=d, y=y, z=z, select.X=FALSE, select.Z=TRUE) 
summary(lasso.IV.Z)
confint(lasso.IV.Z)
}
}
\references{
V. Chernozhukov, C. Hansen, M. Spindler (2015). Post-selection
and post-regularization inference in linear models with many controls and
instruments. American Economic Review: Paper & Proceedings 105(5), 486--490.
}

