% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1_model.R
\name{fit_alasso}
\alias{fit_alasso}
\title{Model selection for high-dimensional Cox models with adaptive lasso penalty}
\usage{
fit_alasso(
  x,
  y,
  nfolds = 5L,
  rule = c("lambda.min", "lambda.1se"),
  seed = c(1001, 1002)
)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}}
for details.}

\item{seed}{Two random seeds for cross-validation fold division
in two estimation steps.}
}
\description{
Automatic model selection for high-dimensional Cox models
with adaptive lasso penalty, evaluated by penalized partial-likelihood.
}
\examples{
data("smart")
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT
y <- survival::Surv(time, event)

fit <- fit_alasso(x, y, nfolds = 3, rule = "lambda.1se", seed = c(7, 11))

nom <- as_nomogram(
  fit, x, time, event,
  pred.at = 365 * 2,
  funlabel = "2-Year Overall Survival Probability"
)

plot(nom)
}
