% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_summaries.R
\name{plot_pexp_beta}
\alias{plot_pexp_beta}
\title{Plot posterior expectation of beta in each context}
\usage{
plot_pexp_beta(
  samples,
  X = NULL,
  W = NULL,
  pred.pexp.beta = FALSE,
  ncol.beta = NULL,
  ylab = NULL,
  nrow.w = NULL,
  ncol.w = NULL,
  smooth.line = FALSE,
  title = NULL,
  legend.position = "top",
  col.pred.line = "red",
  x.axis.size = 1.1,
  y.axis.size = 1.1,
  title.size = 12,
  panel.title.size = 1.4,
  legend.size = 1
)
}
\arguments{
\item{samples}{an output of the function \code{\link{hdpGLM}}}

\item{X}{a string vector with the name of the first-level covariates whose associated tau should be displayed}

\item{W}{a string vector with the name of the context-level covariate(s) whose linear effect will be displayed. If \code{NULL}, the linear effect tau of all context-level covariates are displayed. Note: the context-level covariate must have been included in the estimation of the model.}

\item{pred.pexp.beta}{boolean, if \code{TRUE} the plots will display a line with the predicted posterior expectation of betas obtained using the posterior expectation of taus, the linear coefficients of the expectation of beta}

\item{ncol.beta}{integer with number of columns of the grid used for each group of context-level covariates}

\item{ylab}{string, the label of the y-axis}

\item{nrow.w}{integer with the number of rows of the grid}

\item{ncol.w}{integer with the number of columns of the grid}

\item{smooth.line}{boolean, if \code{TRUE} the plot will display a regression line representing the regression of the posterior expectation of the linear coefficients betas on the context-level covariates. Default \code{FALSE}}

\item{title}{string, title of the plot}

\item{legend.position}{one of four options: "bottom" (default), "top", "left", or "right". It indicates the position of the legend}

\item{col.pred.line}{string with color of fitted line. Only works if \code{pred.pexp.beta=TRUE}}

\item{x.axis.size}{numeric, the relative size of the label in the x-axis}

\item{y.axis.size}{numeric, the relative size of the label in the y-axis}

\item{title.size}{numeric, absolute size of the title}

\item{panel.title.size}{numeric, the relative size of the titles in the panel of the plot}

\item{legend.size}{numeric, the relative size of the legend}
}
\description{
This function plots the posterior expectation of beta, the linear effect of the individual level covariates, as function of the context-level covariates
}
\examples{

library(magrittr)
set.seed(66)

# Note: this example is just for illustration. MCMC iterations are very reduced
set.seed(10)
n = 20
data.context1 = tibble::data_frame(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:3, n, replace=TRUE),
                                   y  =I(z==1) * (3 + 4*x1 - x2 + rnorm(n)) +
                                       I(z==2) * (3 + 2*x1 + x2 + rnorm(n)) +
                                       I(z==3) * (3 - 4*x1 - x2 + rnorm(n)) ,
                                   w = 20
                                   ) 
data.context2 = tibble::data_frame(x1 = rnorm(n, -3),
                                   x2 = rnorm(n,  3),
                                   z  = sample(1:2, n, replace=TRUE),
                                   y  =I(z==1) * (1 + 3*x1 - 2*x2 + rnorm(n)) +
                                       I(z==2) * (1 - 2*x1 +   x2 + rnorm(n)),
                                   w = 10
                                   ) 
data = data.context1 \%>\%
    dplyr::bind_rows(data.context2)

## estimation
mcmc    = list(burn.in=1, n.iter=50)
samples = hdpGLM(y ~ x1 + x2, y ~ w, data=data, mcmc=mcmc, n.display=1)

plot_pexp_beta(samples)
plot_pexp_beta(samples, X='x1', ncol.w=2, nrow.w=1)
plot_pexp_beta(samples, X='x1', ncol.beta=2)
plot_pexp_beta(samples, pred.pexp.beta=TRUE, W="w", X=c("x1", "x2"))
plot_pexp_beta(samples, W='w', smooth.line=TRUE, pred.pexp.beta=TRUE, ncol.beta=2)

}
