% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-process-variable-recommendations.R
\name{build_process_variable_df_list}
\alias{build_process_variable_df_list}
\title{Build a list of dataframes with new predictions for each modifiable variable.}
\usage{
build_process_variable_df_list(dataframe, grain_column_values,
  modifiable_variable_levels, predict_function, smaller_better)
}
\arguments{
\item{dataframe}{A dataframe consisting of deployment data.}

\item{grain_column_values}{The grain column (values, not just the name) of 
the deployment data.}

\item{modifiable_variable_levels}{A list indexed by the modifiable 
process variables and containing the factor levels of each such variable.}

\item{predict_function}{A function with which to make new predictions on the
data.}

\item{smaller_better}{A boolean indicating whether the goal is to
increase or decrease the predictions/predicted probabilities.}
}
\value{
A list of dataframes.
}
\description{
Builds a list consisting of one dataframe per row in
\code{dataframe} which shows how the predictions for that row change as
each of the mofifiable variables are altered
}
\keyword{internal}
