% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_chart.R
\name{control_chart}
\alias{control_chart}
\title{Create a control chart}
\usage{
control_chart(d, measure, x, group1, group2, center_line = mean,
  sigmas = 3, title = NULL, catpion = NULL, font_size = 11,
  print = TRUE)
}
\arguments{
\item{d}{data frame or a path to a csv file that will be read in}

\item{measure}{variable of interest mapped to y-axis (quoted, ie as a string)}

\item{x}{variable to go on the x-axis, often a time variable. If unspecified
row indices will be used (quoted)}

\item{group1}{Optional grouping variable to be panelled horizontally (quoted)}

\item{group2}{Optional grouping variable to be panelled vertically (quoted)}

\item{center_line}{Function used to calculate central tendency. Defaults to
mean}

\item{sigmas}{Number of standard deviations above and below the central
tendency to call a point influenced by "special cause variation." Defaults
to 3}

\item{title}{Title in upper-left}

\item{catpion}{Caption in lower-right}

\item{font_size}{Base font size; text elements will be scaled to this}

\item{print}{Print the plot? Default = TRUE. Set to FALSE if you want to
assign the plot to a variable for further modification, as in the last
example.}
}
\value{
Generally called for the side effect of printing the control chart.
  Invisibly, returns a ggplot object for further customization.
}
\description{
Create a control chart, aka Shewhart chart:
\url{https://en.wikipedia.org/wiki/Control_chart}.
}
\examples{
d <-
  tibble::data_frame(
    day = sample(c("Monday", "Tuesday", "Wednesday", "Thursday", "Friday"),
                 100, TRUE),
    person = sample(c("Tom", "Jane", "Alex"), 100, TRUE),
    count = rbinom(100, 20, ifelse(day == "Friday", .5, .2)),
    date = Sys.Date() - sample.int(100))

# Minimal arguments are the data and the column to put on the y-axis.
# If x is not provided, observations will be plotted in order of the rows

control_chart(d, "count")

# Specify categorical variables for group1 and/or group2 to get a separate
# panel for each category

control_chart(d, "count", group1 = "day", group2 = "person")

# In addition to printing or writing the plot to file, control_chart
# returns the plot as a ggplot2 obejct, which you can then further customize

library(ggplot2)
my_chart <- control_chart(d, "count", "date")
my_chart +
  ylab("Number of Adverse Events") +
  scale_x_date(name = "Week of ... ", date_breaks = "week") +
  theme(axis.text.x = element_text(angle = -90, vjust = 0.5, hjust=1))
}
