% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_thresholds.R
\name{plot.thresholds_df}
\alias{plot.thresholds_df}
\title{Plot threshold performance metrics}
\usage{
\method{plot}{thresholds_df}(x, title = NULL, caption = NULL,
  font_size = 11, line_size = 0.5, point_size = NA, ncol = 2,
  print = TRUE, ...)
}
\arguments{
\item{x}{A \code{threshold_df} object from \code{\link{get_thresholds}} or a
data frame with columns "threshold" and other columns to be plotted against
thresholds. If \code{optimize} was provided to \code{\link{get_thresholds}}
a line is drawn in each facet corresponding to the optimal threshold.}

\item{title}{Plot title. Default NULL produces no title}

\item{caption}{Plot caption. Default NULL produces no caption unless
\code{get_thresholds(optimize)} was provided, in which case information
about the threshold and performance are provided in the caption.}

\item{font_size}{Relative size of all fonts in plot, default = 11}

\item{line_size}{Width of lines, default = 0.5}

\item{point_size}{Point size. Default is \code{NA} which suppresses points.
Set to a number to see where threholds are.}

\item{ncol}{Number of columns of facets.}

\item{print}{Print the plot? Default = TRUE}

\item{...}{Unused}
}
\value{
A ggplot object, invisibly.
}
\description{
Plot threshold performance metrics
}
\examples{
m <- machine_learn(pima_diabetes[1:100, ], patient_id, outcome = diabetes,
                   models = "xgb", tune = FALSE, n_folds = 3)

get_thresholds(m) \%>\%
  plot()

get_thresholds(m, optimize = "cost", measures = c("acc", "cost"), cost_fn = 3) \%>\%
  plot(point_size = .5, ncol = 1)
}
\seealso{
\code{\link{get_thresholds}}
}
