% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_episode.R
\name{collapse_episode}
\alias{collapse_episode}
\title{Grouping records into episodes by date range}
\usage{
collapse_episode(
  data,
  clnt_id,
  start_dt,
  end_dt = NULL,
  gap,
  overwrite = NULL,
  gap_overwrite = Inf,
  .dt_trans = data.table::as.IDate,
  ...
)
}
\arguments{
\item{data}{A data.frame that contains the id and date variables.}

\item{clnt_id}{Column name of subject/person ID.}

\item{start_dt}{Column name of the starting date of records.}

\item{end_dt}{Column name of the end date of records. The default is NULL assuming the record last one day and only the start date will be used to calculate the gaps between records.}

\item{gap}{A number in days that will be used to separate episodes. It should be the inclusive upper bound + 1. For example, gap = 8 means collapsing records no more than 7 days apart.}

\item{overwrite}{Column name of a grouping variable determining whether the consecutive records are related and should have a different gap value. For example, dispensing records may have the same original prescription number, and a different gap value can be assigned for situation, e.g., the days between two records is > gap, but these records still belong to the same prescription.}

\item{gap_overwrite}{A different gap value used for related records. The default is Inf, which means all records with the same overwrite variable will be collapsed.}

\item{.dt_trans}{Function to transform start_dt/end_dt. Default is [data.table::as.IDate()].}

\item{...}{Additional arguments passing to the .dt_trans function.}
}
\value{
The original data.frame with new columns indicating episode grouping
}
\description{
This function is useful for collapsing, e.g., medication dispensation or hospitalization, records into episodes if the records' dates are no more than n days gap apart. The length of the gap can be relaxed by another grouping variable.
}
\examples{
# make toy data
df <- make_test_dat()

head(df)

# collapse records no more than 90 days apart
collapse_episode(df, clnt_id, dates, gap = 91)
}
