% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-scale-zero-one.R
\name{hai_scale_zero_one_vec}
\alias{hai_scale_zero_one_vec}
\title{Vector Function Scale to Zero and One}
\usage{
hai_scale_zero_one_vec(.x)
}
\arguments{
\item{.x}{A numeric vector to be scaled from \verb{[0,1]} inclusive.}
}
\value{
A numeric vector
}
\description{
Takes a numeric vector and will return a vector that has been scaled from \verb{[0,1]}
}
\details{
Takes a numeric vector and will return a vector that has been scaled from \verb{[0,1]}
The input vector must be numeric. The computation is fairly straightforward.
This may be helpful when trying to compare the distributions of data where a
distribution like beta from the \code{fitdistrplus} package which requires data to be
between 0 and 1

\deqn{y[h] = (x - min(x))/(max(x) - min(x))}

This function can be used on it's own. It is also the basis for the function
\code{\link[=hai_scale_zero_one_augment]{hai_scale_zero_one_augment()}}.
}
\examples{
vec_1 <- rnorm(100, 2, 1)
vec_2 <- hai_scale_zero_one_vec(vec_1)

dens_1 <- density(vec_1)
dens_2 <- density(vec_2)
max_x <- max(dens_1$x, dens_2$x)
max_y <- max(dens_1$y, dens_2$y)
plot(dens_1, asp = max_y/max_x, main = "Density vec_1 (Red) and vec_2 (Blue)",
 col = "red", xlab = "", ylab = "Density of Vec 1 and Vec 2")
lines(dens_2, col = "blue")

}
\seealso{
Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_kurtosis_vec}()},
\code{\link{hai_scale_zscore_vec}()},
\code{\link{hai_skewness_vec}()},
\code{\link{hai_winsorized_move_vec}()},
\code{\link{hai_winsorized_truncate_vec}()}

Other Scale: 
\code{\link{hai_scale_zero_one_augment}()},
\code{\link{hai_scale_zscore_augment}()},
\code{\link{hai_scale_zscore_vec}()},
\code{\link{step_hai_scale_zscore}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Scale}
\concept{Vector Function}
