% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate-metrics-collection.R
\name{hai_auto_wflw_metrics}
\alias{hai_auto_wflw_metrics}
\title{Collect Metrics from Boilerplat Workflows}
\usage{
hai_auto_wflw_metrics(.data)
}
\arguments{
\item{.data}{The output of the \code{hai_auto_} boilerplate function in it's entirety.}
}
\value{
A tibble
}
\description{
This function will extract the metrics from the \code{hai_auto_} boilerplate
functions.
}
\details{
This function will extract the metrics from the \code{hai_auto_} boilerplate
functions. This function looks for a specific attribute from the \code{hai_auto_}
functions so that it will extract the \code{tuned_results} from the tuning process
if it has indeed been tuned.
}
\examples{
\dontrun{
data <- iris

rec_obj <- hai_knn_data_prepper(data, Species ~ .)

auto_knn <- hai_auto_knn(
  .data = data,
  .rec_obj = rec_obj,
  .best_metric = "f_meas",
  .model_type = "classification",
  .grid_size = 2,
  .num_cores = 4
)

hai_auto_wflw_metrics(auto_knn)
}

}
\seealso{
Other Boiler_Plate: 
\code{\link{hai_auto_c50}()},
\code{\link{hai_auto_cubist}()},
\code{\link{hai_auto_earth}()},
\code{\link{hai_auto_glmnet}()},
\code{\link{hai_auto_knn}()},
\code{\link{hai_auto_ranger}()},
\code{\link{hai_auto_svm_poly}()},
\code{\link{hai_auto_svm_rbf}()},
\code{\link{hai_auto_xgboost}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Boiler_Plate}
\concept{Metric_Collection}
