% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-lag-correlation.R
\name{ts_lag_correlation}
\alias{ts_lag_correlation}
\title{Time Series Lag Correlation Analysis}
\usage{
ts_lag_correlation(
  .data,
  .date_col,
  .value_col,
  .lags = 1,
  .heatmap_color_low = "white",
  .heatmap_color_hi = "steelblue"
)
}
\arguments{
\item{.data}{A tibble of time series data}

\item{.date_col}{A date column}

\item{.value_col}{The value column being analyzed}

\item{.lags}{This is a vector of integer lags, ie 1 or c(1,6,12)}

\item{.heatmap_color_low}{What color should the low values of the heatmap of
the correlation matrix be, the default is 'white'}

\item{.heatmap_color_hi}{What color should the low values of the heatmap of
the correlation matrix be, the default is 'steelblue'}
}
\value{
A list object
}
\description{
This function outputs a list object of both data and plots.

The data output are the following:
\itemize{
\item lag_list
\item lag_tbl
\item correlation_lag_matrix
\item correlation_lag_tbl
}

The plots output are the following:
\itemize{
\item lag_plot
\item plotly_lag_plot
\item correlation_heatmap
\item plotly_heatmap
}
}
\details{
This function takes in a time series data in the form of a tibble and
outputs a list object of data and plots. This function will take in an argument
of '.lags' and get those lags in your data, outputting a correlation matrix,
heatmap and lag plot among other things of the input data.
}
\examples{
library(dplyr)

df <- ts_to_tbl(AirPassengers) \%>\% select(-index)
lags <- c(1,3,6,12)

output <- ts_lag_correlation(
  .data = df,
  .date_col = date_col,
  .value_col = value,
  .lags = lags
)

output$data$correlation_lag_matrix
output$plots$lag_plot

}
\seealso{
Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()},
\code{\link{util_difflog_ts}()},
\code{\link{util_doublediff_ts}()},
\code{\link{util_doubledifflog_ts}()},
\code{\link{util_log_ts}()},
\code{\link{util_singlediff_ts}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
